<?php
class ModelShippingSpeedy extends Model {

	function getQuote($address) {
		$this->language->load('shipping/speedy');

		if (isset($address['validate'])) {
			$status = true;
		} else {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('speedy_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

			if (!$this->config->get('speedy_geo_zone_id')) {
				$status = true;
			} elseif ($query->num_rows) {
				$status = true;
			} else {
				$status = false;
			}
		}

		$method_data = array();

		if ($status) {
			$quote_data = array();

			$quote_data['speedy'] = array(
				'code'         => 'speedy.speedy',
				'title'        => $this->language->get('text_description'),
				'cost'         => 0.00,
				'tax_class_id' => 0,
				'text'         => ''
			);

			$method_data = array(
				'code'       => 'speedy',
				'title'      => $this->language->get('text_title'),
				'quote'      => $quote_data,
				'sort_order' => $this->config->get('speedy_sort_order'),
				'error'      => false
			);

			if (isset($this->session->data['speedy']) &&
				($this->customer->isLogged() && isset($this->session->data['shipping_address']['address_id'])
				&& isset($this->session->data['speedy_customer']) &&
				$this->session->data['speedy_customer']['shipping_address_id'] == $this->session->data['shipping_address']['address_id'] ||
				isset($this->session->data['guest']) && isset($this->session->data['speedy_guest']) &&
				$this->session->data['speedy_guest']['city'] == $this->session->data['shipping_address']['city'] &&
				$this->session->data['speedy_guest']['postcode'] == $this->session->data['shipping_address']['postcode'] ||
				isset($this->session->data['api_id']))
			) {
				require_once(DIR_SYSTEM . 'library/speedy.php');
				$speedy = new Speedy($this->registry);

				$total = 0;
				$totalNoShipping = $total;
				$taxes = $this->cart->getTaxes();
				$sort_order = array();

				if (version_compare(VERSION, '2.2', '>=')) {
					$totals = array();
					// Because __call can not keep var references so we put them into an array.
					$total_data = array(
						'totals' => &$totals,
						'taxes'  => &$taxes,
						'total'  => &$total
					);
				}

				if (isset($this->session->data['coupon'])) {
					if (version_compare(VERSION, '2.0.0.0', '>=') && version_compare(VERSION, '2.1.0.0', '<')) {
						$this->load->model('checkout/coupon');

						$coupon_info = $this->model_checkout_coupon->getCoupon($this->session->data['coupon']);
					} elseif (version_compare(VERSION, '2.1.0.0', '>') && version_compare(VERSION, '2.3.0.0', '<')) {
						$this->load->model('total/coupon');

						$coupon_info = $this->model_total_coupon->getCoupon($this->session->data['coupon']);
					} elseif(version_compare(VERSION, '2.3.0.0', '>=')) {
						$this->load->model('extension/total/coupon');

						$coupon_info = $this->model_extension_total_coupon->getCoupon($this->session->data['coupon']);
					}

					$coupon = $this->session->data['coupon'];
				}

				$this->load->model('extension/extension');
				$results = $this->model_extension_extension->getExtensions('total');

				foreach ($results as $key => $value) {
					$sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
				}

				array_multisort($sort_order, SORT_ASC, $results);

				foreach ($results as $result) {
					if ($this->config->get($result['code'] . '_status')) {
						if ($result['code'] != 'shipping' || (isset($coupon_info) && !empty($coupon_info['shipping']))) {
							if (version_compare(VERSION, '2.2.0.0', '>')) {
								$this->load->model('extension/total/' . $result['code']);

								$this->{'model_extension_total_' . $result['code']}->getTotal($total_data);
							} else {
								$this->load->model('total/' . $result['code']);

								$this->{'model_total_' . $result['code']}->getTotal($total_data, $total, $taxes);
							}
						}
					}
				}

				if (!empty($coupon)) {
					$this->session->data['coupon'] = $coupon;
				}

				$total = $this->currency->convert((float)$total, $this->config->get('config_currency'), $this->session->data['currency']);
				$weight = 0;

				foreach ($this->cart->getProducts() as $product) {
					if ($product['shipping']) {
						$product_weight = (float)$product['weight'];
						if (!empty($product_weight)) {
							$weight += $this->weight->convert($product['weight'], $product['weight_class_id'], 1);
						} else {
							$weight += ($this->config->get('speedy_default_weight') * $product['quantity']);
						}

						$totalNoShipping += $this->tax->calculate($product['price'], $product['tax_class_id'], $this->session->data['currency']) * $product['quantity'];
					}
				}

				$this->session->data['speedy']['total'] = number_format($total, 2, '.', '');
				$this->session->data['speedy']['totalNoShipping'] = number_format($this->currency->convert((float)$totalNoShipping, $this->config->get('config_currency'), $this->session->data['currency']), 2, '.', '');
				$this->session->data['speedy']['order_currency_code'] = $this->session->data['currency'];
				$this->session->data['speedy']['weight'] = $weight;
				$this->session->data['speedy']['count'] = 1; //$this->cart->countProducts();
				$this->session->data['speedy']['taking_date'] = ($this->config->get('speedy_taking_date') ? strtotime('+' . (int)$this->config->get('speedy_taking_date') . ' day', mktime(9, 0, 0)) : time());
				$this->session->data['speedy']['client_id'] = $this->config->get('speedy_client_id');

				if (!Speedy::NEW_API) {
					$this->session->data['speedy']['convertion_to_win1251'] = $this->config->get('speedy_convertion_to_win1251');
				}

				if ($this->config->get('speedy_pricing') == 'fixed' || $this->config->get('speedy_pricing') == 'calculator_fixed') {
					$this->session->data['speedy']['total'] += $this->currency->convert((float)$this->config->get('speedy_fixed_price'), $speedy->baseCurrency, $this->session->data['currency']);
				}

				if (!$this->config->get('speedy_cod_status')) {
					$this->session->data['speedy']['cod'] = false;
				}

				if ($weight > Speedy::MAX_PARCEL_WEIGHT) {
					$this->session->data['speedy']['parcels_size'] = array(
						1 => array(
							'weight' => $weight,
							'width'  => 120,
							'height' => 100,
							'depth'  => 80,
						)
					);
				} else {
					$this->session->data['speedy']['parcels_size'] = array(
						1 => array(
							'weight' => '',
							'width'  => '',
							'height' => '',
							'depth'  => '',
						)
					);
				}
                if (!isset($this->session->data['speedy']['abroad'])) {
                    $this->session->data['speedy']['abroad'] = 0;
                }

				$lang = ($this->session->data['speedy']['abroad']) ? 'en' : $this->language->get('code');
				$services = $speedy->getServices($lang);
				$methods_count = 0;

				if (isset($address['validate']) || !isset($this->session->data['speedy_guest_address']) || (isset($this->session->data['speedy_guest_address']) && md5(serialize($this->session->data['speedy_guest_address'])) == md5(serialize($address)))) {
					$session = $this->session->data['speedy'];
					$methods = $speedy->calculate($session);
				} else {
					$methods = array();
				}

				if (!$speedy->getError()) {
					foreach ($methods as $method) {
						if (empty($method['error'])) {
							if (($this->config->get('speedy_pricing') == 'free') && ($this->currency->convert((float)$total, $this->session->data['currency'], $speedy->baseCurrency) >= (float)$this->config->get('speedy_free_shipping_total')) &&
								($method['serviceId'] == $this->config->get('speedy_free_method_city') || $method['serviceId'] == $this->config->get('speedy_free_method_intercity') || in_array($method['serviceId'], $this->config->get('speedy_free_method_international')))) {
								$method_total = 0;
							} elseif ($this->config->get('speedy_pricing') == 'fixed') {
								$method_total = $this->config->get('speedy_fixed_price');
							} elseif ($this->config->get('speedy_pricing') == 'table_rate') {
								$filter_data = array(
									'service_id' => $method['serviceId'],
									'take_from_office' => $this->session->data['speedy']['to_office'],
									'weight' => $weight,
									'order_total' => $this->currency->convert((float)$total, $this->session->data['currency'], $speedy->baseCurrency),
								);

								$speedy_table_rate = $this->getSpeedyTableRate($filter_data);

								if (empty($speedy_table_rate)) {
									continue;
								} else {
									$method_total = $speedy_table_rate['price_without_vat'];
								}
							} else {
								$method_total = $method['price']['total'];

								if ($this->config->get('speedy_pricing') == 'calculator_fixed') {
									$method_total += $this->config->get('speedy_fixed_price');
								}
							}

							if ($this->currency->has($speedy->baseCurrency)) {
								$method_cost = $this->currency->convert((float)$method_total, $speedy->baseCurrency, $this->config->get('config_currency'));// Винаги връща в BGN
								$method_text = $this->currency->convert((float)$method_total, $speedy->baseCurrency, $this->session->data['currency']);
							} else {
								$method_cost = $method_total;
								$method_text = $method_total;
							}

							$method_title = $this->language->get('text_description') . ' - ' . $services[$method['serviceId']];

							$quote_data[$method['serviceId']] = array(
								'code'         => 'speedy.' . $method['serviceId'],
								'title'        => $method_title,
								'cost'         => $method_cost,
								'tax_class_id' => 0,
								'text'         => $this->currency->format($method_text, $this->session->data['currency'], 1)
							);

							$methods_count++;
						}
					}

					if ($methods_count) {
						unset($quote_data['speedy']);
						$method_data['quote'] = $quote_data;
					} elseif (!$methods_count && $this->config->get('speedy_pricing') == 'table_rate') {
						$method_data['speedy_error'] = $this->language->get('error_calculate_table_rate');
					} else {
						$method_data['speedy_error'] = $this->language->get('error_calculate_empty_methods');
					}
				} else {
					$method_data['speedy_error'] = $speedy->getError();
				}
			} else {
				$method_data['speedy_error'] = $this->language->get('error_calculate');
				unset($this->session->data['speedy']);
			}
		}

		if (isset($method_data['speedy_error'])) {
			$method_data['quote']['speedy']['text'] = '';
			$this->session->data['speedy_error'] = $method_data['speedy_error'];
		}

		return $method_data;
	}

	public function addAddress($address_id, $data) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "speedy_address WHERE address_id = '" . (int)$address_id . "' AND customer_id = '" . (int)$this->customer->getId() . "'");

		$this->db->query("INSERT INTO " . DB_PREFIX . "speedy_address SET
		address_id = '" . (int)$address_id . "',
		customer_id = '" . (int)$this->customer->getId() . "',
		postcode = '" . (isset($data['postcode']) ? $this->db->escape($data['postcode']) : 0) . "',
		city = '" . (isset($data['city']) ? $this->db->escape($data['city']) : '') . "',
		city_id = '" . (isset($data['city_id']) ? (int)$data['city_id'] : 0) . "',
		city_nomenclature = '" . (isset($data['city_nomenclature']) ? $this->db->escape($data['city_nomenclature']) : '') . "',
		is_apt = '" . (isset($data['is_apt']) ? (int)$data['is_apt'] : 0) . "',
		to_office = '" . (isset($data['to_office']) ? (int)$data['to_office'] : 0) . "',
		office_id = '" . (isset($data['office_id']) ? (int)$data['office_id'] : 0) . "',
		quarter = '" . (isset($data['quarter']) ? $this->db->escape($data['quarter']) : '') . "',
		quarter_id = '" . (isset($data['quarter_id']) ? (int)$data['quarter_id'] : 0) . "',
		street_type = '" . (isset($data['street_type']) ? $this->db->escape($data['street_type']) : '') . "',
		street = '" . (isset($data['street']) ? $this->db->escape($data['street']) : '') . "',
		street_id = '" . (isset($data['street_id']) ? (int)$data['street_id'] : 0) . "',
		street_no = '" . (isset($data['street_no']) ? $this->db->escape($data['street_no']) : '') . "',
		block_no = '" . (isset($data['block_no']) ? $this->db->escape($data['block_no']) : '') . "',
		entrance_no = '" . (isset($data['entrance_no']) ? $this->db->escape($data['entrance_no']) : '') . "',
		floor_no = '" . (isset($data['floor_no']) ? $this->db->escape($data['floor_no']) : '') . "',
		apartment_no = '" . (isset($data['apartment_no']) ? $this->db->escape($data['apartment_no']) : '') . "',
		note = '" . (isset($data['note']) ? $this->db->escape($data['note']) : '') . "',
		country = '" . (isset($data['country']) ? $this->db->escape($data['country']) : '') . "',
		country_id = '" . (isset($data['country_id']) ? (int)$data['country_id'] : 0) . "',
		country_nomenclature = '" . (isset($data['country_nomenclature']) ? $this->db->escape($data['country_nomenclature']) : '') . "',
		state = '" . (isset($data['state']) ? $this->db->escape($data['state']) : '') . "',
		state_id = '" . (isset($data['state_id']) ? $this->db->escape($data['state_id']) : '') . "',
		required_state = '" . (isset($data['required_state']) ? (int)$data['required_state'] : 0) . "',
		required_postcode = '" . (isset($data['required_postcode']) ? (int)$data['required_postcode'] : 0) . "',
		address_1 = '" . (isset($data['address_1']) ? $this->db->escape($data['address_1']) : '') . "',
		address_2 = '" . (isset($data['address_2']) ? $this->db->escape($data['address_2']) : '') . "',
		abroad = '" . (isset($data['abroad']) ? (int)$data['abroad'] : 0) . "'");
	}

	public function getAddress($address_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "speedy_address WHERE address_id = '" . (int)$address_id . "' AND customer_id = '" . (int)$this->customer->getId() . "'");

		return $query->row;
	}

	public function addOrder($order_id, $data) {
		$data['price_gen_method'] = $this->config->get('speedy_pricing');
		$this->db->query("INSERT INTO " . DB_PREFIX . "speedy_order SET order_id = '" . (int)$order_id . "', data = '" . $this->db->escape(serialize($data)) . "'");
	}

	public function getOrder($order_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "speedy_order WHERE order_id = '" . (int)$order_id . "'");

		return $query->row;
	}

	public function editOrder($order_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "speedy_order SET data = '" . $this->db->escape(serialize($data)) . "' WHERE order_id = '" . (int)$order_id . "'");
	}

	public function getSpeedyTableRate($data) {
		$query = $this->db->query("SELECT price_without_vat FROM " . DB_PREFIX . "speedy_table_rate WHERE service_id = '" . (int)$data['service_id'] . "' AND take_from_office = '" . (int)$data['take_from_office'] . "' AND weight >= '" . (float)$data['weight'] . "' AND order_total >= '" . (int)$data['order_total'] . "' ORDER BY weight, order_total ASC");

		return $query->row;
	}

	// sorts the array by quantity without deleting the keys
	private function cmp($a, $b) {
		if ($a == $b) {
			return 0;
		}
		return ($a < $b) ? -1 : 1;
	}
}