<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">
  <div class="page-header">
	<div class="container-fluid">
	  <?php if ($courier) { ?>
	  <div class="pull-right">
		<button type="submit" id="button-shipping" form="form" formaction="<?php echo $courier; ?>" data-toggle="tooltip" title="<?php echo $button_courier; ?>" class="btn btn-primary"><i class="fa fa-truck"></i> <?php echo $button_courier; ?></button>
	  </div>
	  <?php } ?>
	  <h1><?php echo $heading_title; ?></h1>
	  <ul class="breadcrumb">
		<?php foreach ($breadcrumbs as $breadcrumb) { ?>
		<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
		<?php } ?>
	  </ul>
	</div>
  </div>
  <div class="container-fluid">
	<?php if ($error_warning) { ?>
	<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
	  <button type="button" class="close" data-dismiss="alert">&times;</button>
	</div>
	<?php } ?>
	<?php if ($success) { ?>
	<div class="alert alert-success"><i class="fa fa-check-circle"></i> <?php echo $success; ?>
	  <button type="button" class="close" data-dismiss="alert">&times;</button>
	</div>
	<?php } ?>
	<div class="panel panel-default">
	  <div class="panel-heading">
		<h3 class="panel-title"><i class="fa fa-list"></i> <?php echo $text_list; ?></h3>
	  </div>
	  <div class="panel-body">
		<div class="well">
		  <div class="row">
			<div class="col-sm-3">
			  <div class="form-group">
				<label class="control-label" for="input-bol-id"><?php echo $column_bol_id; ?></label>
				<input type="text" name="filter_bol_id" value="<?php echo $filter_bol_id; ?>" placeholder="<?php echo $column_bol_id; ?>" id="input-bol-id" class="form-control" />
			  </div>
			</div>
			<div class="col-sm-3">
			  <div class="form-group">
				<label class="control-label" for="input-order-id"><?php echo $column_order_id; ?></label>
				<input type="text" name="filter_order_id" value="<?php echo $filter_order_id; ?>" placeholder="<?php echo $column_order_id; ?>" id="input-order-id" class="form-control" />
			  </div>
			</div>
			<div class="col-sm-3">
			  <div class="form-group">
				<label class="control-label" for="input-customer"><?php echo $column_customer; ?></label>
				<input type="text" name="filter_customer" value="<?php echo $filter_customer; ?>" placeholder="<?php echo $column_customer; ?>" id="input-customer" class="form-control" />
			  </div>
			</div>
			<div class="col-sm-3">
			  <div class="form-group">
				<label class="control-label" for="input-date-created"><?php echo $column_date_created; ?></label>
				<div class="input-group date">
				  <input type="text" name="filter_date_created" value="<?php echo $filter_date_created; ?>" placeholder="<?php echo $column_date_created; ?>" data-date-format="YYYY-MM-DD" id="input-date-created" class="form-control" />
				  <span class="input-group-btn">
				  <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
				  </span></div>
			  </div>
			  <button type="button" id="button-filter" class="btn btn-primary pull-right"><i class="fa fa-search"></i> <?php echo $button_filter; ?></button>
			</div>
		  </div>
		</div>
		<form method="post" enctype="multipart/form-data" id="form">
		  <div class="table-responsive">
			<table class="table table-bordered table-hover">
			  <thead>
				<tr>
				  <td  style="width: 1px;" class="text-center"><input type="checkbox" onclick="$('input[name*=\'selected\']').attr('checked', this.checked);" /></td>
				  <td class="text-right"><?php if ($sort == 'so.bol_id') { ?>
					<a href="<?php echo $sort_speedy_order; ?>" class="<?php echo strtolower($order); ?>"><?php echo $column_bol_id; ?></a>
					<?php } else { ?>
					<a href="<?php echo $sort_speedy_order; ?>"><?php echo $column_bol_id; ?></a>
					<?php } ?></td>
				  <td class="text-right"><?php if ($sort == 'so.order_id') { ?>
					<a href="<?php echo $sort_order; ?>" class="<?php echo strtolower($order); ?>"><?php echo $column_order_id; ?></a>
					<?php } else { ?>
					<a href="<?php echo $sort_order; ?>"><?php echo $column_order_id; ?></a>
					<?php } ?></td>
				  <td class="text-left"><?php if ($sort == 'customer') { ?>
					<a href="<?php echo $sort_customer; ?>" class="<?php echo strtolower($order); ?>"><?php echo $column_customer; ?></a>
					<?php } else { ?>
					<a href="<?php echo $sort_customer; ?>"><?php echo $column_customer; ?></a>
					<?php } ?></td>
				  <td class="text-left"><?php echo $column_recipient; ?></td>
				  <td class="text-left"><?php if ($sort == 'so.date_created') { ?>
					<a href="<?php echo $sort_date_created; ?>" class="<?php echo strtolower($order); ?>"><?php echo $column_date_created; ?></a>
					<?php } else { ?>
					<a href="<?php echo $sort_date_created; ?>"><?php echo $column_date_created; ?></a>
					<?php } ?></td>
					<td class="text-left"><?php echo $column_delivery_date; ?></td>
					<td class="text-left"><?php echo $column_status; ?></td>
					<td class="text-left"><?php echo $column_order_address; ?></td>
				  <td class="text-right"><?php echo $column_action; ?></td>
				</tr>
			  </thead>
			  <tbody>
				<?php if ($speedy_orders) { ?>
				<?php foreach ($speedy_orders as $order) { ?>
				<tr>
					<td class="text-center"><?php if (in_array($order['order_id'], $selected)) { ?>
					<input type="checkbox" name="selected[]" value="<?php echo $order['order_id']; ?>" checked="checked" />
					<?php } else { ?>
					<input type="checkbox" name="selected[]" value="<?php echo $order['order_id']; ?>" />
					<?php } ?></td>
					<td class="text-right"><a href="<?php echo $order['bol_href']; ?>" <?php if (!empty($order['bol_target'])) { ?> target="<?php echo $order['bol_target']; ?>"<?php } ?>><?php echo $order['bol_id']; ?></a></td>
					<td class="text-right"><a href="<?php echo $order['order_href']; ?>"><?php echo $order['order_id']; ?></a></td>
					<td class="text-left"><?php echo $order['customer']; ?></td>
					<td class="text-left"><?php echo $order['recipient'] ?></td>
					<td class="text-left"><?php echo $order['date_created']; ?></td>
					<td class="text-left"><?php echo $order['delivery_date']; ?> <?php if (!empty($order['delivery_consignee'])) { ?> <br /> <?php echo $order['delivery_consignee']; } ?><?php if(!empty($order['delivery_note'])) { ?> , <?php echo $order['delivery_note']; } ?></td>
					<td class="text-left"><?php echo $order['status']; ?></td>
					<td class="text-left"><?php echo $order['address']; ?></td>
					<td class="text-right"><?php foreach ($order['action'] as $action) { ?>
					[ <?php if (!empty($action['href'])) { ?><a href="<?php echo $action['href']; ?>" <?php if (!empty($action['target'])) { ?> target="<?php echo $action['target']; ?>"<?php } ?>><?php echo $action['text']; ?></a><?php } else { ?><?php echo $action['text']; ?><?php } ?> ]
					<?php } ?></td>
				</tr>
				<?php } ?>
				<?php } else { ?>
				<tr>
				  <td  class="text-center" colspan="10"><?php echo $text_no_results; ?></td>
				</tr>
				<?php } ?>
			  </tbody>
			</table>
		  </div>
		</form>
		<div class="row">
		  <div class="col-sm-6 text-left"><?php echo $pagination; ?></div>
		  <div class="col-sm-6 text-right"><?php echo $results; ?></div>
		</div>
	  </div>
	</div>
  </div>
<script type="text/javascript"><!--
$('#button-filter').on('click', function() {

	url = 'index.php?route=sale/speedy&token=<?php echo $token; ?>';

	var filter_bol_id = $('input[name=\'filter_bol_id\']').val();

	if (filter_bol_id) {
		url += '&filter_bol_id=' + encodeURIComponent(filter_bol_id);
	}

	var filter_order_id = $('input[name=\'filter_order_id\']').val();

	if (filter_order_id) {
		url += '&filter_order_id=' + encodeURIComponent(filter_order_id);
	}

	var filter_customer = $('input[name=\'filter_customer\']').val();

	if (filter_customer) {
		url += '&filter_customer=' + encodeURIComponent(filter_customer);
	}

	var filter_date_created = $('input[name=\'filter_date_created\']').val();

	if (filter_date_created) {
		url += '&filter_date_created=' + encodeURIComponent(filter_date_created);
	}

	location = url;
});
//--></script>
  <script src="view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
  <link href="view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css" type="text/css" rel="stylesheet" media="screen" />
  <script type="text/javascript"><!--
$('.date').datetimepicker({
	pickTime: false
});
//--></script></div>
<script type="text/javascript"><!--
$('#form input').keydown(function(e) {
	if (e.keyCode == 13) {
		filter();
	}
});
//--></script>
<script type="text/javascript"><!--

$('input[name=\'filter_customer\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=sale/customer/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent($('input[name=\'filter_customer\']').val()),
			dataType: 'json',
			success: function(json) {
				response($.map(json, function(item) {
					return {
						category: item.customer_group,
						label: item.name,
						value: item.customer_id
					}
				}));
			}
		});
	},
	'select': function(item) {
		if (item) {
			$('input[name=\'filter_customer\']').val(item.label);
		}
	},
	'focus': function(item) {
		return false;
	}
});
//--></script>
<?php echo $footer; ?>