<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">
  <div class="page-header">
    <div class="container-fluid">
      <div class="pull-right">
        <a id="createBillOfLading" onclick="speedySubmit();" class="btn btn-primary"><?php echo $button_create; ?></a>
        <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a>
      </div>
      <h1><?php echo $heading_title; ?></h1>
      <ul class="breadcrumb">
        <?php foreach ($breadcrumbs as $breadcrumb) { ?>
        <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
        <?php } ?>
      </ul>
    </div>
  </div>
  <div class="container-fluid">
    <?php if ($error_warning) { ?>
      <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
        <button type="button" class="close" data-dismiss="alert">&times;</button>
      </div>
    <?php } ?>
    <div class="panel panel-default">
      <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $heading_title; ?></h3>
      </div>
      <div class="panel-body">
        <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-speedy" class="form-horizontal">
          <input id="speedy_taking_date" type="hidden" name="taking_date" value="<?php echo $taking_date; ?>" />
          <div class="form-group required">
            <label class="col-sm-3 control-label" for="speedy_contents"><?php echo $entry_contents; ?></label>
            <div class="col-sm-9">
              <input class="form-control" type="text" id="speedy_contents" name="contents" value="<?php echo $contents; ?>" />
              <?php if ($error_contents) { ?>
                <span class="text-danger"><?php echo $error_contents; ?></span>
              <?php } ?>
            </div>
          </div>
          <div class="form-group required">
            <label class="col-sm-3 control-label" for="speedy_weight"><?php echo $entry_weight; ?> <a target="_blank" href="https://services.speedy.bg/api/speedy_modules_settings.html#weight"><i class="fa fa-question-circle"></i></a></label>
            <div class="col-sm-9">
              <input class="form-control" type="text" id="speedy_weight" name="weight" value="<?php echo $weight; ?>" />
              <?php if ($error_weight) { ?>
                <span class="text-danger"><?php echo $error_weight; ?></span>
              <?php } ?>
            </div>
          </div>
          <div class="form-group required">
            <label class="col-sm-3 control-label" for="speedy_packing"><?php echo $entry_packing; ?><a target="_blank" href="https://services.speedy.bg/api/speedy_modules_settings.html#package"><i class="fa fa-question-circle"></i></a></label>
            <div class="col-sm-9">
              <input class="form-control" type="text" id="speedy_packing" name="packing" value="<?php echo $packing; ?>" />
              <?php if ($error_packing) { ?>
                <span class="text-danger"><?php echo $error_packing; ?></span>
              <?php } ?>
            </div>
          </div>
          <div class="form-group required">
            <label class="col-sm-3 control-label" for="client_id"><?php echo $entry_client_id; ?><a target="_blank" href="https://services.speedy.bg/api/speedy_modules_settings.html#pickUpOffice"><i class="fa fa-question-circle"></i></a></label>
            <div class="col-sm-9">
              <select name="client_id" id="client_id" class="form-control">
                <?php foreach ($clients as $client) { ?>
                  <?php if ($client['clientId'] == $client_id) { ?>
                    <option value="<?php echo $client['clientId']; ?>" selected="selected"><?php echo sprintf($text_client_id, $client['clientId'], $client['name'], $client['address']); ?></option>
                  <?php } else { ?>
                    <option value="<?php echo $client['clientId']; ?>"><?php echo sprintf($text_client_id, $client['clientId'], $client['name'], $client['address']); ?></option>
                  <?php } ?>
                <?php } ?>
              </select>
            </div>
          </div>
          <div class="form-group">
            <label class="col-sm-3 control-label" for="speedy_payer_type"><?php echo $entry_payer_type; ?></label>
            <div class="col-sm-9">
              <select class="form-control" id="speedy_payer_type" name="payer_type">
                <?php if ($payer_type) { ?>
                  <option value="1" selected="selected"><?php echo $text_receiver; ?></option>
                  <option value="0"><?php echo $text_sender; ?></option>
                <?php } else { ?>
                  <option value="1"><?php echo $text_receiver; ?></option>
                  <option value="0" selected="selected"><?php echo $text_sender; ?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          <div class="form-group required" style="<?php echo $shipping_method_id == 500 ? 'display:none' : ''; ?>">
            <label class="col-sm-3 control-label" for="speedy_count"><?php echo $entry_count; ?></label>
            <div class="col-sm-9">
              <input class="form-control" type="text" id="speedy_count" name="count" value="<?php echo $count; ?>" />
              <?php if ($error_count) { ?>
                <span class="text-danger"><?php echo $error_count; ?></span>
              <?php } ?>
            </div>
          </div>
          <div class="form-group" style="<?php echo $shipping_method_id == 500 ? 'display:none' : ''; ?>">
            <label class="col-sm-3 control-label" for="speedy_width"><?php echo $entry_size; ?></label>
            <div class="table-responsive col-sm-9">
              <table id="parcels_size" class="table table-striped table-bordered table-hover">
                <thead>
                  <tr>
                    <td class="text-left"><?php echo $entry_width; ?></td>
                    <td class="text-left"><?php echo $entry_height; ?></td>
                    <td class="text-left"><?php echo $entry_depth; ?></td>
                    <td class="text-left"><?php echo $entry_parcel_weight; ?></td>
                  </tr>
                </thead>
                <tbody>
                  <?php $parcels_size_row = 1; ?>
                  <?php foreach ($parcels_sizes as $parcels_size) { ?>
                    <tr id="parcel-size-row<?php echo $parcels_size_row; ?>">
                      <td class="text-left">
                        <input type="text" name="parcels_size[<?php echo $parcels_size_row; ?>][width]" value="<?php echo $parcels_size['width']; ?>" placeholder="<?php echo $entry_width; ?>" class="form-control" />
                      </td>
                      <td class="text-left">
                        <input type="text" name="parcels_size[<?php echo $parcels_size_row; ?>][height]" value="<?php echo $parcels_size['height']; ?>" placeholder="<?php echo $entry_height; ?>" class="form-control" />
                      </td>
                      <td class="text-left">
                        <input type="text" name="parcels_size[<?php echo $parcels_size_row; ?>][depth]" value="<?php echo $parcels_size['depth']; ?>" placeholder="<?php echo $entry_depth; ?>" class="form-control" />
                      </td>
                      <td class="text-left">
                        <input type="text" name="parcels_size[<?php echo $parcels_size_row; ?>][weight]" value="<?php echo $parcels_size['weight']; ?>" placeholder="<?php echo $entry_parcel_weight; ?>" class="form-control" />
                      </td>
                    </tr>
                    <?php $parcels_size_row++; ?>
                  <?php } ?>
                </tbody>
              </table>
            </div>
          </div>
          <div class="form-group">
            <label class="col-sm-3 control-label" for="speedy_deffered_days"><?php echo $entry_deffered_days; ?><a target="_blank" href="https://services.speedy.bg/api/speedy_modules_settings.html#postponeShipmentsDays"><i class="fa fa-question-circle"></i></a></label>
            <div class="col-sm-9">
              <select class="form-control" id="speedy_deffered_days" name="deffered_days">
                <?php foreach ($days as $day_id => $day) { ?>
                  <?php if ($day_id == $deffered_days) { ?>
                    <option value="<?php echo $day_id; ?>" selected="selected"><?php echo $day; ?></option>
                  <?php } else { ?>
                    <option value="<?php echo $day_id; ?>"><?php echo $day; ?></option>
                  <?php } ?>
                <?php } ?>
              </select>
            </div>
          </div>
          <div class="form-group">
            <label class="col-sm-3 control-label" for="speedy_client_note"><?php echo $entry_client_note; ?></label>
            <div class="col-sm-9">
              <input class="form-control" type="text" id="speedy_client_note" name="client_note" value="<?php echo $client_note; ?>" />
            </div>
          </div>
          <div class="form-group" id="speedy_cod_container" <?php if (!$cod_status) { ?> style="display: none;"<?php } ?> >
            <label class="col-sm-3 control-label"><?php echo $entry_cod; ?></label>
            <div class="col-sm-9">
              <label class="radio-inline" style="display: inline; width: auto; float: none;">
                <input type="radio" id="speedy_cod_yes" name="cod" value="1" <?php if ($cod) { ?> checked="checked"<?php } ?> onclick="$('#speedy_total_container').show(); $('#speedy_option_before_payment_container').show();" />
              <?php echo $text_yes; ?>
              </label>
              <label class="radio-inline" style="display: inline; width: auto; float: none;">
                <input type="radio" id="speedy_cod_no" name="cod" value="0" <?php if (!$cod) { ?> checked="checked"<?php } ?> onclick="$('#speedy_total_container').hide(); $('#speedy_option_before_payment_container').hide();" />
              <?php echo $text_no; ?>
              </label>
            </div>
          </div>
          <div class="form-group" id="speedy_total_container" <?php if (!$cod_status || !$cod) { ?> style="display: none;"<?php } ?> >
            <label class="col-sm-3 control-label" for="speedy_total"><?php echo $entry_total; ?></label>
            <div class="col-sm-9">
              <input class="form-control" type="text" id="speedy_total" name="total" value="<?php echo $total; ?>" />
            </div>
          </div>
          <?php if (!empty($entry_convertion_to_win1251)) { ?>
          <div class="form-group">
            <label class="col-sm-3 control-label" for="speedy_convertion_to_win1251"><?php echo $entry_convertion_to_win1251; ?></label>
            <div class="col-sm-9">
              <select class="form-control" id="speedy_convertion_to_win1251" name="convertion_to_win1251">
                <?php if ($convertion_to_win1251) { ?>
                  <option value="1" selected="selected"><?php echo $text_yes; ?></option>
                  <option value="0"><?php echo $text_no; ?></option>
                <?php } else { ?>
                  <option value="1"><?php echo $text_yes; ?></option>
                  <option value="0" selected="selected"><?php echo $text_no; ?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          <?php } ?>
          <div class="form-group">
            <label class="col-sm-3 control-label" for="speedy_additional_copy_for_sender"><?php echo $entry_additional_copy_for_sender; ?>
               <a target="_blank" href="https://services.speedy.bg/api/speedy_modules_settings.html#additionalWaybillPaperCopy"><i class="fa fa-question-circle"></i></a>
            </label>
            <div class="col-sm-9">
              <select class="form-control" id="speedy_additional_copy_for_sender" name="additional_copy_for_sender">
                <?php if ($additional_copy_for_sender) { ?>
                  <option value="1" selected="selected"><?php echo $text_yes; ?></option>
                  <option value="0"><?php echo $text_no; ?></option>
                <?php } else { ?>
                  <option value="1"><?php echo $text_yes; ?></option>
                  <option value="0" selected="selected"><?php echo $text_no; ?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          <div class="form-group">
            <label class="col-sm-3 control-label" for="speedy_saturday_delivery"><?php echo $entry_saturday_delivery; ?>
               <a target="_blank" href="https://services.speedy.bg/api/speedy_modules_settings.html#saturdayDelivery"><i class="fa fa-question-circle"></i></a>
            </label>
            <div class="col-sm-9">
              <select class="form-control" id="speedy_saturday_delivery" name="saturday_delivery">
                <?php if ($saturday_delivery) { ?>
                  <option value="1" selected="selected"><?php echo $text_yes; ?></option>
                  <option value="0"><?php echo $text_no; ?></option>
                <?php } else { ?>
                  <option value="1"><?php echo $text_yes; ?></option>
                  <option value="0" selected="selected"><?php echo $text_no; ?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          <?php if (!$abroad) { ?>
            <div class="form-group" id="speedy_option_before_payment_container" <?php if (!$cod_status || !$cod) { ?> style="display: none;" <?php } ?>>
              <label class="col-sm-3 control-label" for="speedy_option_before_payment"><?php echo $entry_options_before_payment; ?>
                <a target="_blank" href="https://services.speedy.bg/api/speedy_modules_settings.html#obpd"><i class="fa fa-question-circle"></i></a>
              </label>
              <div class="col-sm-9">
                <select name="option_before_payment" id="speedy_option_before_payment" class="form-control">
                  <?php foreach ($options_before_payment as $option_id => $option) { ?>
                    <?php if ($option_id == $option_before_payment) { ?>
                      <option value="<?php echo $option_id; ?>" selected="selected"><?php echo $option; ?></option>
                    <?php } else { ?>
                      <option value="<?php echo $option_id; ?>"><?php echo $option; ?></option>
                    <?php } ?>
                  <?php } ?>
                </select>
              </div>
            </div>
          <?php } ?>
          <div class="form-group">
            <label class="col-sm-3 control-label" for="speedy_insurance"><?php echo $entry_insurance; ?>
              <a target="_blank" href="https://services.speedy.bg/api/speedy_modules_settings.html#declaredValue"><i class="fa fa-question-circle"></i></a>
            </label>
            <div class="col-sm-9">
              <select class="form-control" id="speedy_insurance" name="insurance" onchange="$('#speedy_fragile').parent().parent().toggle(); $('#speedy_total_insurance').parent().parent().toggle();">
                <?php if ($insurance) { ?>
                  <option value="1" selected="selected"><?php echo $text_yes; ?></option>
                  <option value="0"><?php echo $text_no; ?></option>
                <?php } else { ?>
                  <option value="1"><?php echo $text_yes; ?></option>
                  <option value="0" selected="selected"><?php echo $text_no; ?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          <div class="form-group" <?php if (!$insurance) { ?> style="display: none;"<?php } ?> >
            <label class="col-sm-3 control-label" for="speedy_fragile"><span data-toggle="tooltip" title="<?php echo $help_fragile; ?>"><?php echo $entry_fragile; ?></span><a target="_blank" href="https://services.speedy.bg/api/speedy_modules_settings.html#declaredValue"><i class="fa fa-question-circle"></i></a></label>
            <div class="col-sm-9">
              <select class="form-control" id="speedy_fragile" name="fragile">
                <?php if ($fragile) { ?>
                  <option value="1" selected="selected"><?php echo $text_yes; ?></option>
                  <option value="0"><?php echo $text_no; ?></option>
                <?php } else { ?>
                  <option value="1"><?php echo $text_yes; ?></option>
                  <option value="0" selected="selected"><?php echo $text_no; ?></option>
                <?php } ?>
              </select>
            </div>
          </div>
          <div class="form-group" <?php if (!$insurance) { ?> style="display: none;"<?php } ?> >
            <label class="col-sm-3 control-label" for="speedy_total_insurance"><?php echo $entry_total_insurance; ?></label>
            <div class="col-sm-9">
              <input class="form-control" type="text" id="speedy_total_insurance" name="totalNoShipping" value="<?php echo $totalNoShipping; ?>" />
            </div>
          </div>
          <?php if ($speedy_one_field_address) { ?>
          <div class="form-group" id="one_field_notice" <?php if ($to_office) { ?> style="display: none;"<?php } ?>>
            <label class="col-sm-3 control-label" for="speedy_one_field_address"><?php echo $entry_one_field_address; ?></label>
            <div class="col-sm-9">
              <p class="alert alert-info"><?php echo $text_one_field_notice; ?></p>
            </div>
          </div>
          <?php } ?>
          <?php if (!$abroad) { ?>
            <input type="hidden" id="speedy_country_id" name="country_id" value="<?php echo $country_id; ?>" />
            <div class="form-group">
              <label class="col-sm-3 control-label" for="speedy_city"><?php echo $entry_city; ?></label>
              <div class="col-sm-6">
                <input class="form-control" type="text" id="speedy_city" name="city" value="<?php echo $city; ?>" />
              </div>
              <input type="hidden" id="speedy_city_id" name="city_id" value="<?php echo $city_id; ?>" />
              <input type="hidden" id="speedy_city_nomenclature" name="city_nomenclature" value="<?php echo $city_nomenclature; ?>" />
              <label class="col-sm-1 control-label" for="speedy_postcode"><?php echo $entry_postcode; ?></label>
              <div class="col-sm-1">
                <input class="form-control" type="text" id="speedy_postcode" name="postcode" value="<?php echo $postcode; ?>" disabled="disabled" />
              </div>
            </div>
            <div class="form-group" id="to_office" <?php if (empty($offices)) { ?>style="display:none;" <?php } ?>>
              <label class="col-sm-3 control-label"><?php echo $entry_shipping_to; ?></label>
              <div class="col-sm-9">
                <label class="radio-inline" style="display: inline; width: auto; float: none;">
                  <input type="radio" id="speedy_shipping_to_apt" data-is-apt="1" name="to_office" value="1" <?php if ($to_office && $is_apt) { ?> checked="checked"<?php } ?> />
                  <span>
                    <?php
                        if ($option_before_payment == 'test' && $ignore_obp) {
                            echo $text_to_apt_ignore_obp_test;
                        } else if ($option_before_payment == 'open' && $ignore_obp) {
                            echo $text_to_apt_ignore_obp_open;
                        } else {
                            echo $text_to_apt;
                        }
                    ?>
                    </span>
                </label>
                <label class="radio-inline" style="display: inline; width: auto; float: none;">
                  <input type="radio" id="speedy_shipping_to_office" data-is-apt="0" name="to_office" value="1" <?php if ($to_office && !$is_apt) { ?> checked="checked"<?php } ?> />
                  <span><?php echo $text_to_office; ?></span>
                </label>
                <label class="radio-inline" style="display: inline; width: auto; float: none;">
                  <input type="radio" id="speedy_shipping_to_door" data-is-apt="0" name="to_office" value="0" <?php if (!$to_office && !$is_apt) { ?> checked="checked"<?php } ?> />
                  <span><?php echo $text_to_door; ?></span>
                </label>
              </div>
            </div>
            <div class="form-group" id="speedy_quarter_container" <?php if ($to_office) { ?> style="display: none;"<?php } ?> >
              <label class="col-sm-3 control-label" for="speedy_quarter"><?php echo $entry_quarter; ?></label>
              <div class="col-sm-9">
                <input class="form-control" type="text" id="speedy_quarter" name="quarter" value="<?php echo $quarter; ?>" />
                <input type="hidden" id="speedy_quarter_id" name="quarter_id" value="<?php echo $quarter_id; ?>" />
              </div>
            </div>
            <div class="form-group" id="speedy_street_container" <?php if ($to_office) { ?> style="display: none;"<?php } ?> >
              <label class="col-sm-3 control-label" for="speedy_street"><?php echo $entry_street; ?><span><?php echo $street_type_span; ?></span></label>
              <div class="col-sm-6">
                <input class="form-control" type="text" id="speedy_street" name="street" value="<?php echo $street; ?>" />
                <input type="hidden" id="speedy_street_id" name="street_id" value="<?php echo $street_id; ?>" />
                <input type="hidden" id="speedy_street_type" name="street_type" value="<?php echo $street_type; ?>" />
                <?php if ($error_address) { ?>
                  <span class="text-danger"><?php echo $error_address; ?></span>
                <?php } ?>
              </div>
              <label class="col-sm-1 control-label" for="speedy_street_no"><?php echo $entry_street_no; ?></label>
              <div class="col-sm-1">
                <input class="form-control" type="text" id="speedy_street_no" name="street_no" value="<?php echo $street_no; ?>" />
              </div>
            </div>
            <div class="form-group" id="speedy_block_no_container" <?php if ($to_office) { ?> style="display: none;"<?php } ?> >
              <label class="col-sm-3 control-label" for="speedy_block_no"><?php echo $entry_block_no; ?></label>
              <div class="col-sm-2">
                <input class="form-control" type="text" id="speedy_block_no" name="block_no" value="<?php echo $block_no; ?>" />
              </div>
              <label class="col-sm-1 control-label" for="speedy_entrance_no"><?php echo $entry_entrance_no; ?></label>
              <div class="col-sm-1">
                <input class="form-control" type="text" id="speedy_entrance_no" name="entrance_no" value="<?php echo $entrance_no; ?>" />
              </div>
              <label class="col-sm-1 control-label" for="speedy_floor_no"><?php echo $entry_floor_no; ?></label>
              <div class="col-sm-1">
                <input class="form-control" type="text" id="speedy_floor_no" name="floor_no" value="<?php echo $floor_no; ?>" />
              </div>
              <label class="col-sm-1 control-label" for="speedy_apartment_no"><?php echo $entry_apartment_no; ?></label>
              <div class="col-sm-1">
                <input class="form-control" type="text" id="speedy_apartment_no" name="apartment_no" value="<?php echo $apartment_no; ?>" />
              </div>
            </div>
            <div class="form-group" id="speedy_note_container" <?php if ($to_office) { ?> style="display: none;"<?php } ?> >
              <label class="col-sm-3 control-label" for="speedy_note"><?php echo $entry_note; ?></label>
              <div class="col-sm-9">
                <input class="form-control" type="text" id="speedy_note" name="note" value="<?php echo $note; ?>" />
              </div>
            </div>
            <div class="form-group" id="speedy_office_container" <?php if (!$to_office) { ?> style="display: none;"<?php } ?> >
              <label class="col-sm-3 control-label" for="speedy_office_id"><?php echo $entry_office; ?></label>
              <div class="col-sm-9">
                <select class="form-control" id="speedy_office_id" name="office_id">
                  <?php if (!empty($to_office) && !empty($is_apt)) { ?>
                    <option value="0" selected="selected"><?php echo $text_select_apt; ?></option>
                  <?php } else { ?>
                    <option value="0" selected="selected"><?php echo $text_select_office; ?></option>
                  <?php } ?>
                  <?php foreach ($offices as $office) { ?>
                    <?php if ($office['id'] == $office_id) { ?>
                      <?php if (!($office['is_apt'] xor $is_apt)) { ?>
                        <option value="<?php echo $office['id']; ?>" data-is-apt="<?php echo $office['is_apt']; ?>" selected="selected"><?php echo $office['label']; ?></option>
                      <?php } ?>
                    <?php } else { ?>
                      <option value="<?php echo $office['id']; ?>" data-is-apt="<?php echo $office['is_apt']; ?>"><?php echo $office['label']; ?></option>
                    <?php } ?>
                  <?php } ?>
                </select>
                <input type="hidden" id="office_name" name="office_name" value="<?php echo $office_name; ?>" />
                <input type="hidden" id="is_apt" name="is_apt" value="<?php echo $is_apt; ?>" />
                <?php if ($error_office) { ?>
                  <br />&nbsp;&nbsp;&nbsp;<span class="text-danger"><?php echo $error_office; ?></span>
                <?php } ?>
              </div>
            </div>
          <?php } else { ?>
            <div class="form-group">
              <div class="required">
                <label class="col-sm-3 control-label" for="speedy_country"><?php echo $entry_country; ?></label>
                <div class="col-sm-5">
                  <input type="text" id="speedy_country" name="country" value="<?php echo $country; ?>" class="form-control" />
                </div>
              </div>
              <div id="abroad_speedy_state" class="<?php if ($required_state) { ?>required<?php } ?>">
                <label class="col-sm-1 control-label" for="speedy_state"><?php echo $entry_state; ?></label>
                <div class="col-sm-2">
                  <input type="text" id="speedy_state" name="state" value="<?php echo $state; ?>" class="form-control" />
                  <input type="hidden" id="speedy_state_id" name="state_id" value="<?php echo $state_id; ?>" />
                  <input type="hidden" id="required_state" name="required_state" value="<?php echo $required_state; ?>" />
                </div>
              </div>
            </div>
            <div class="form-group">
              <div class="required">
                <label class="col-sm-3 control-label" for="speedy_city"><?php echo $entry_city; ?></label>
                <div class="col-sm-5">
                  <input type="text" id="speedy_city" name="city" value="<?php echo $city; ?>" class="form-control" />
                  <input type="hidden" id="speedy_city_id" name="city_id" value="<?php echo $city_id; ?>" />
                  <input type="hidden" id="speedy_city_nomenclature" name="city_nomenclature" value="<?php echo $city_nomenclature; ?>" />
                </div>
              </div>
              <div id="abroad_speedy_postcode" class="<?php if ($required_postcode) { ?>required<?php } ?>">
                <label class="col-sm-1 control-label" for="speedy_postcode"><?php echo $entry_postcode; ?></label>
                <div class="col-sm-2">
                  <input type="text" id="speedy_postcode" name="postcode" value="<?php echo $postcode; ?>" class="form-control" />
                  <input type="hidden" id="required_postcode" name="required_postcode" value="<?php echo $required_postcode; ?>" />
                </div>
              </div>
            </div>
            <div class="form-group" id="to_office" <?php if (empty($offices)) { ?>style="display:none;" <?php } ?>>
              <label class="col-sm-3 control-label"><?php echo $entry_shipping_to; ?></label>
              <div class="col-sm-9">
                <label class="radio-inline" style="display: inline; width: auto; float: none;">
                  <input type="radio" id="speedy_shipping_to_apt" data-is-apt="1" name="to_office" value="1" <?php if ($to_office && $is_apt) { ?> checked="checked"<?php } ?> />
                  <span>
                    <?php
                        if ($option_before_payment == 'test' && $ignore_obp) {
                            echo $text_to_apt_ignore_obp_test;
                        } else if ($option_before_payment == 'open' && $ignore_obp) {
                            echo $text_to_apt_ignore_obp_open;
                        } else {
                            echo $text_to_apt;
                        }
                    ?>
                  </span>
                </label>
                <label class="radio-inline" style="display: inline; width: auto; float: none;">
                  <input type="radio" id="speedy_shipping_to_office" data-is-apt="0" name="to_office" value="1" <?php if ($to_office && !$is_apt) { ?> checked="checked"<?php } ?> />
                  <span><?php echo $text_to_office; ?></span>
                </label>
                <label class="radio-inline" style="display: inline; width: auto; float: none;">
                  <input type="radio" id="speedy_shipping_to_door" data-is-apt="0" name="to_office" value="0" <?php if (!$to_office && !$is_apt) { ?> checked="checked"<?php } ?> />
                  <span><?php echo $text_to_door; ?></span>
                </label>
              </div>
            </div>
            <div id="country_has_address_nomenclature" <?php if (!$country_address_nomenclature) { ?> style="display: none;"<?php } ?> >
              <div class="form-group" id="speedy_quarter_container" <?php if ($to_office) { ?> style="display: none;"<?php } ?>>
                <label class="col-sm-3 control-label" for="speedy_quarter"><?php echo $entry_quarter; ?></label>
                <div class="col-sm-9">
                  <input class="form-control" type="text" id="speedy_quarter" name="quarter" value="<?php echo $quarter; ?>" />
                  <input type="hidden" id="speedy_quarter_id" name="quarter_id" value="<?php echo $quarter_id; ?>" />
                </div>
              </div>
              <div class="form-group" id="speedy_street_container" <?php if ($to_office) { ?> style="display: none;"<?php } ?>>
                <label class="col-sm-3 control-label" for="speedy_street"><?php echo $entry_street; ?><span><?php echo $street_type_span; ?></span></label>
                <div class="col-sm-6">
                  <input class="form-control" type="text" id="speedy_street" name="street" value="<?php echo $street; ?>" />
                  <input type="hidden" id="speedy_street_id" name="street_id" value="<?php echo $street_id; ?>" />
                  <input type="hidden" id="speedy_street_type" name="street_type" value="<?php echo $speedy_street_type; ?>" />
                  <?php if ($error_address) { ?>
                    <span class="text-danger"><?php echo $error_address; ?></span>
                  <?php } ?>
                </div>
                <label class="col-sm-1 control-label" for="speedy_street_no"><?php echo $entry_street_no; ?></label>
                <div class="col-sm-1">
                  <input class="form-control" type="text" id="speedy_street_no" name="street_no" value="<?php echo $street_no; ?>" />
                </div>
              </div>
              <div class="form-group" id="speedy_block_no_container" <?php if ($to_office) { ?> style="display: none;"<?php } ?>>
                <label class="col-sm-3 control-label" for="speedy_block_no"><?php echo $entry_block_no; ?></label>
                <div class="col-sm-2">
                  <input class="form-control" type="text" id="speedy_block_no" name="block_no" value="<?php echo $block_no; ?>" />
                </div>
                <label class="col-sm-1 control-label" for="speedy_entrance_no"><?php echo $entry_entrance_no; ?></label>
                <div class="col-sm-1">
                  <input class="form-control" type="text" id="speedy_entrance_no" name="entrance_no" value="<?php echo $entrance_no; ?>" />
                </div>
                <label class="col-sm-1 control-label" for="speedy_floor_no"><?php echo $entry_floor_no; ?></label>
                <div class="col-sm-1">
                  <input class="form-control" type="text" id="speedy_floor_no" name="floor_no" value="<?php echo $floor_no; ?>" />
                </div>
                <label class="col-sm-1 control-label" for="speedy_apartment_no"><?php echo $entry_apartment_no; ?></label>
                <div class="col-sm-1">
                  <input class="form-control" type="text" id="speedy_apartment_no" name="apartment_no" value="<?php echo $apartment_no; ?>" />
                </div>
              </div>
              <div class="form-group" id="speedy_note_container" <?php if ($to_office) { ?> style="display: none;"<?php } ?>>
                <label class="col-sm-3 control-label" for="speedy_note"><?php echo $entry_note; ?></label>
                <div class="col-sm-9">
                  <input class="form-control" type="text" id="speedy_note" name="note" value="<?php echo $note; ?>" />
                </div>
              </div>
              <div class="form-group" id="speedy_office_container" <?php if (!$to_office) { ?> style="display: none;"<?php } ?>>
                <label class="col-sm-3 control-label" for="speedy_office_id"><?php echo $entry_office; ?></label>
                <div class="col-sm-9">
                  <select class="form-control" id="speedy_office_id" name="office_id">
                    <?php if (!empty($to_office) && !empty($is_apt)) { ?>
                      <option value="0" selected="selected"><?php echo $text_select_apt; ?></option>
                    <?php } else { ?>
                      <option value="0" selected="selected"><?php echo $text_select_office; ?></option>
                    <?php } ?>
                    <?php foreach ($offices as $office) { ?>
                      <?php if ($office['id'] == $office_id) { ?>
                        <?php if (!($office['is_apt'] xor $is_apt)) { ?>
                          <option value="<?php echo $office['id']; ?>" data-is-apt="<?php echo $office['is_apt']; ?>" selected="selected"><?php echo $office['label']; ?></option>
                        <?php } ?>
                      <?php } else { ?>
                        <option value="<?php echo $office['id']; ?>" data-is-apt="<?php echo $office['is_apt']; ?>"><?php echo $office['label']; ?></option>
                      <?php } ?>
                    <?php } ?>
                  </select>
                  <input type="hidden" id="office_name" name="office_name" value="<?php echo $office_name; ?>" />
                  <input type="hidden" id="is_apt" name="is_apt" value="<?php echo $is_apt; ?>" />
                  <?php if ($error_office) { ?>
                    <br />&nbsp;&nbsp;&nbsp;<span class="text-danger"><?php echo $error_office; ?></span>
                  <?php } ?>
                </div>
              </div>
            </div>
            <div id="country_has_no_address_nomenclature" <?php if ($country_address_nomenclature) { ?> style="display: none;"<?php } ?>>
              <div class="form-group required">
                <label class="col-sm-3 control-label" for="speedy_address_1"><?php echo $entry_address_1; ?></label>
                <div class="col-sm-8">
                  <input type="text" id="speedy_address_1" name="address_1" value="<?php echo $address_1; ?>" class="form-control" />
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label" for="speedy_address_2"><?php echo $entry_address_2; ?></label>
                <div class="col-sm-8">
                  <input type="text" id="speedy_address_2" name="address_2" value="<?php echo $address_2; ?>" class="form-control" />
                </div>
              </div>
            </div>
          <?php } ?>
          <input type="hidden" id="abroad" name="abroad" value="<?php echo $abroad; ?>" />
          <?php if (!empty($quote)) { ?>
            <div class="form-group">
              <label class="col-sm-3 control-label"><?php echo $entry_shipping_method; ?></label>
              <div class="col-sm-9">
                <?php foreach ($quote['quote'] as $shipping_method_key_id => $shipping_method) { ?>
                <div class="radio">
                  <label>
                    <input type="radio" id="<?php echo $shipping_method['code']; ?>" data-shipping_method_id="<?php echo $shipping_method_key_id; ?>" name="shipping_method" value="<?php echo $shipping_method['code']; ?>" <?php if ($shipping_method_key_id == $shipping_method_id) { ?> checked="checked"<?php } ?> />
                    <?php echo $shipping_method['title']; ?>&nbsp;<?php echo $shipping_method['text']; ?>
                  </label>
                </div>
                <?php } ?>
              </div>
            </div>
          <?php } ?>
          <div class="form-group">
            <b><label class="col-sm-3 control-label" for="speedy_note"><?php echo $text_calculate; ?></label></b>
            <div class="col-sm-9">
              <input type="hidden" id="speedy_country_id" name="country_id" value="<?php echo $country_id; ?>" />
              <input type="hidden" id="speedy_country_nomenclature" name="country_nomenclature" value="<?php echo $country_nomenclature; ?>" />
              <input type="hidden" id="speedy_active_currency_code" name="active_currency_code" value="<?php echo $active_currency_code; ?>" />
              <input type="hidden" id="calculate" name="calculate" value="0" />
              <input type="hidden" id="recalculate" name="recalculate" value="0" />
              <a onclick="$('#calculate').val('1'); $('#form-speedy :input').removeAttr('disabled'); $('#form-speedy').submit();" class="btn btn-primary"><?php echo $button_calculate; ?></a>
            </div>
          </div>
        </form>
        <div class="text-center">
        <a id="createBillOfLading" onclick="speedySubmit();" class="btn btn-primary"><?php echo $button_create; ?></a>
        <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a>
      </div>
      </div>
    </div>
  </div>
</div>
<script type="text/javascript"><!--
$('#client_id').on('change', function() {
  if ($('#recalculate').val() == 0) {
    alert("<?php echo $error_recalculate; ?>");

    $('#createBillOfLading').attr('disabled', 'disabled');
    $('#recalculate').val('1');
  }
});
function speedySubmit() {
    $('#createBillOfLading').attr('disabled', 'disabled');
  if ($('[name="shipping_method"][value^="speedy."]:checked').length) {
    var shipping_method_id = $('[name="shipping_method"][value^="speedy."]:checked').data('shipping_method_id');
  } else {
    var shipping_method_id = '<?php echo $shipping_method_id; ?>';
  }
  var post_data = {
    'shipping_method_id'  : shipping_method_id,
    'abroad'              : $('#abroad').val()
  };

  if(!parseInt($('#abroad').val())) {
    post_data.speedy_shipping_to_office = $('input[name=to_office]:checked').val();
    post_data.speedy_option_before_payment = $('#speedy_option_before_payment').val();
    post_data.speedy_city_id = $('#speedy_city_id').val();
    post_data.speedy_office_id = $('#speedy_office_id').val();
  }

  $.ajax({
    url: 'index.php?route=sale/speedy/validateBillOfLading&token=<?php echo $token; ?>',
    type: 'POST',
    data: post_data,
    dataType: 'json',
    success: function(data) {
      if (data.error) {
        var confurm = 1;

        if (data.taking_date) {
          $('#speedy_taking_date').val(data.taking_date);
        }

        for(error in data.errors) {
          if (!confirm(data.errors[error])) {
            confurm = 0;
          }
        }

        if(confurm) {
          $('#form-speedy :input').removeAttr('disabled');
          $('#form-speedy').submit();
        } else {
          $('#createBillOfLading').removeAttr('disabled');
        }
      } else {
        $('#form-speedy :input').removeAttr('disabled');
        $('#form-speedy').submit();
      }
    },
    error: function(xhr, ajaxOptions, thrownError) {
        $('#createBillOfLading').removeAttr('disabled');
      //alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
    }
  });
}

var speedy_count_previous;

$('#speedy_count').keydown(function (e) {
  if (!e.key.match(/\d/)) {
    e.preventDefault()
  }
}).on('focus', function () {
  speedy_count_previous = parseInt($(this).val());
}).change(function() {
  // Do something with the previous value after the change

  if (parseInt(speedy_count_previous) < parseInt($(this).val())) {
    addParcelsSize(parseInt(speedy_count_previous) + 1, parseInt($(this).val()));
  } else {
    removeParcelsSize(parseInt($(this).val()), parseInt(speedy_count_previous));
  }

  // Make sure the previous value is updated
  speedy_count_previous = parseInt($(this).val());
});

function addParcelsSize(old_rows, new_rows) {
  for (i = old_rows; i <= new_rows; i++) {
    html  = '<tr id="parcel-size-row' + i + '">';
    html += '  <td class="text-left"><input type="text" name="parcels_size[' + i + '][width]" value="" placeholder="<?php echo $entry_width; ?>" class="form-control" /></td>';
    html += '  <td class="text-left"><input type="text" name="parcels_size[' + i + '][height]" value="" placeholder="<?php echo $entry_height; ?>" class="form-control" /></td>';
    html += '  <td class="text-left"><input type="text" name="parcels_size[' + i + '][depth]" value="" placeholder="<?php echo $entry_depth; ?>" class="form-control" /></td>';
    html += '  <td class="text-left"><input type="text" name="parcels_size[' + i + '][weight]" value="" placeholder="<?php echo $entry_parcel_weight; ?>" class="form-control" /></td>';
    html += '</tr>';

    $('#parcels_size tbody').append(html);
  }
}

function removeParcelsSize(old_rows, new_rows) {
  for (i = new_rows; i > old_rows; i--) {
    $('#parcel-size-row' + i).remove();
  }
}

var speedy_city = '<?php echo $city; ?>';
var speedy_quarter = '<?php echo $quarter; ?>';
var speedy_street = '<?php echo $street; ?>';

var speedy_country = '<?php echo $country; ?>';
var speedy_state = '<?php echo $state; ?>';

$(document).ready(function() {
  $('#speedy_city').autocomplete({
    'source': function(request, response) {
      if (request) {
        $.ajax({
          url: 'index.php?route=sale/speedy/getCities&token=<?php echo $token; ?>',
          dataType: 'json',
        type: 'get',
        data: {
          term: function() { return $('#speedy_city').val(); },
          country_id: $('#speedy_country_id').val(),
          abroad: $('#abroad').val()
        },
          success: function(json) {
            if ($('#speedy_city').is(":focus")) {
              response($.map(json, function(item) {
                return {
                  label:        item['label'],
                  value:        item['value'],
                  id:           item['id'],
                  postcode:     item['postcode'],
                  nomenclature: item['nomenclature']
                }
              }));
            }
          }
        });
      }
    },
    'select': function(item) {
      if (item) {
        speedy_city = item.value;
        $('#speedy_city').val(item.value);
        $('#speedy_postcode').val(item.postcode);
        $('#speedy_city_id').val(item.id);
        $('#speedy_city_nomenclature').val(item.nomenclature);
        $('#speedy_quarter').val('');
        $('#speedy_quarter_id').val('');
        $('#speedy_street').val('');
        $('#speedy_street_id').val('');
        $('#speedy_street_no').val('');
        $('#speedy_street_type').val('');
        $('[for="speedy_street"] span').text('');
        $('#speedy_block_no').val('');
        $('#speedy_entrance_no').val('');
        $('#speedy_floor_no').val('');
        $('#speedy_apartment_no').val('');
        $('#speedy_note').val('');
        $('#speedy_office_id').html('<option value="0"><?php echo $text_wait; ?></option>');
/*
        if (ui.item.nomenclature == 'NO') {
          $('#speedy_quarter, #speedy_street').autocomplete('option', 'disabled', true);
        } else {
          $('#speedy_quarter, #speedy_street').autocomplete('option', 'disabled', false);
        }
*/
        $.ajax({
          url: 'index.php?route=sale/speedy/getOffices&token=<?php echo $token; ?>',
          dataType: 'json',
          data: {
            city_id: item.id,
            abroad: $('#abroad').val(),
            country_id: $('#speedy_country_id').val()
          },
          success: function(data) {
            if (data.error) {
              alert(data.error);
            } else {
              html = '';

              if (data.length) {
                var hasApt = false;
                var hasOffices = false;

                html += '<option value="0"><?php echo $text_select_office; ?></option>';
                for (i = 0; i < data.length; i++) {
                  html += '<option value="' + data[i]['id'] + '" data-is-apt="' + data[i]['is_apt'] + '">' + data[i]['label'] + '</option>';

                  if (data[i]['is_apt'] == 1) {
                    hasApt = true;
                  }

                  if (data[i]['is_apt'] == 0) {
                    hasOffices = true;
                  }
                }

                if ($('#to_office:hidden').length == 1
                    || (hasApt && $('#speedy_shipping_to_apt:checked'))
                    || (hasOffices && $('#speedy_shipping_to_office:checked'))
                ) {
                    if (hasApt) {
                        $('#speedy_shipping_to_apt').trigger('click');
                    } else if (hasOffices) {
                        $('#speedy_shipping_to_office').trigger('click');
                    }
                }

                $('#speedy_shipping_to_apt').parent().toggle(hasApt);
                $('#speedy_shipping_to_office').parent().toggle(hasOffices);

                $('#to_office').show();
              } else {
                $('#speedy_shipping_to_door').trigger('click');
                $('#to_office').hide();
              }

              $('#speedy_office_id').html(html);
            }
          },
          error: function(xhr, ajaxOptions, thrownError) {
            //alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
          }
        });
      }
    },
    'change': function(item) {
      if(!item && $('#speedy_country_nomenclature').val() == 'FULL') {
        $('#speedy_city').val('');
        $('#speedy_city_id').val('');
        $('#speedy_city_nomenclature').val('');
        $('#speedy_postcode').val('');
        $('#speedy_office_id').html('<option value="0"><?php echo $text_select_city; ?></option>');
      }

      $('#speedy_quarter').val('');
      $('#speedy_quarter_id').val('');
      $('#speedy_street').val('');
      $('#speedy_street_id').val('');
      $('#speedy_street_no').val('');
      $('#speedy_street_type').val('');
      $('[for="speedy_street"] span').text('');
      $('#speedy_block_no').val('');
      $('#speedy_entrance_no').val('');
      $('#speedy_floor_no').val('');
      $('#speedy_apartment_no').val('');
      $('#speedy_note').val('');
    }
  });

  $('#speedy_city').blur(function() {
    if ($(this).val() != speedy_city) {

      if (!$('#abroad').val() || ($('#abroad').val() && ($('#speedy_country_nomenclature').val() == 'FULL'))) {
        $('#speedy_city').val('');
      }

      $('#speedy_city_id').val('');
      $('#speedy_city_nomenclature').val('');
      $('#speedy_postcode').val('');
      $('#speedy_office_id').html('<option value="0"><?php echo $text_select_city; ?></option>');
      $('#speedy_quarter').val('');
      $('#speedy_quarter_id').val('');
      $('#speedy_street').val('');
      $('#speedy_street_id').val('');
      $('#speedy_street_no').val('');
      $('#speedy_street_type').val('');
      $('[for="speedy_street"] span').text('');
      $('#speedy_block_no').val('');
      $('#speedy_entrance_no').val('');
      $('#speedy_floor_no').val('');
      $('#speedy_apartment_no').val('');
      $('#speedy_note').val('');
    }
  });

  $('#speedy_quarter').autocomplete({
    'source': function(request, response) {
      if (request) {
        $.ajax({
          url: 'index.php?route=sale/speedy/getQuarters&token=<?php echo $token; ?>',
          dataType: 'json',
          data: {
            term: function() { return $('#speedy_quarter').val(); },
            city_id: function() { return $('#speedy_city_id').val(); },
            abroad: $('#abroad').val()
          },
          success: function(data) {
            if (data.error) {
              $('#speedy_quarter').val('');
              $('#speedy_quarter_id').val('');
              alert(data.error);
            } else {
              if ($('#speedy_city_nomenclature').val() == 'FULL') {
                if (data.length) {
                  response($.map(data, function(item) {
                    return {
                      label: item['label'],
                      value: item['value'],
                      id: item['id'],
                    }
                  }));
                }
              } else {
                response($.map(data, function(item) {
                  return {
                    label: item['label'],
                    value: item['value'],
                    id: item['id'],
                  }
                }));
              }
            }
          },
          error: function(xhr, ajaxOptions, thrownError) {
            //alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
          }
        });
      }
    },
    'select': function(item) {
      if (item) {
        speedy_quarter = item.value;
        $('#speedy_quarter').val(item.value);
        $('#speedy_quarter_id').val(item.id);
      }
    },
    'change': function(item) {
      if(!item && $('#speedy_city_nomenclature').val() == 'FULL') {
        $('#speedy_quarter').val('');
        $('#speedy_quarter_id').val('');
      }
    }
  });

  $('#speedy_quarter').blur(function() {
    if (($(this).val() != speedy_quarter) && ($('#speedy_city_nomenclature').val() == 'FULL')) {
      $('#speedy_quarter').val('');
      $('#speedy_quarter_id').val('');
    }
  });

  $('#speedy_street').autocomplete({
    'source': function(request, response) {
      if (request) {
        $.ajax({
          url: 'index.php?route=sale/speedy/getStreets&token=<?php echo $token; ?>',
          dataType: 'json',
          data: {
            term: function() { return $('#speedy_street').val(); },
            city_id: function() { return $('#speedy_city_id').val(); },
            abroad: $('#abroad').val()
          },
          success: function(data) {
            if (data.error) {
              $('#speedy_street').val('');
              $('#speedy_street_id').val('');
              $('#speedy_street_type').val('');
              $('[for="speedy_street"] span').text('');
              alert(data.error);
            } else {
              if ($('#speedy_city_nomenclature').val() == 'FULL') {
                if (data.length) {
                  response($.map(data, function(item) {
                    return {
                      label: item['label'],
                      value: item['label'],
                      name: item['value']['name'],
                      type: item['value']['type'],
                      id: item['id']
                    }
                  }));
                }
              } else {
                response($.map(data, function(item) {
                  return {
                      label: item['label'],
                      value: item['label'],
                      name: item['value']['name'],
                      type: item['value']['type'],
                      id: item['id']
                  }
                }));
              }
            }
          },
          error: function(xhr, ajaxOptions, thrownError) {
            //alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
          }
        });
      }
    },
    'select': function(item) {
      if (item) {
        speedy_street = item.name;
        $('#speedy_street').val(speedy_street);
        $('#speedy_street_id').val(item.id);
        $('#speedy_street_type').val(item.type);
        $('[for="speedy_street"] span').text(' (' +  item.type + ')');
      }
    },
    'change': function(item) {
      if(!item) {
        if(!item && $('#speedy_city_nomenclature').val() == 'FULL') {
          $('#speedy_street').val('');
          $('#speedy_street_id').val('');
          $('#speedy_street_type').val('');
          $('[for="speedy_street"] span').text('');
        }
      }
    }
  });

  $('#speedy_street').blur(function() {
    if (($(this).val() != speedy_street) && ($('#speedy_city_nomenclature').val() == 'FULL')) {
      $('#speedy_street').val('');
      $('#speedy_street_id').val('');
      $('#speedy_street_type').val('');
      $('[for="speedy_street"] span').text('');
    }
  });

  $('#speedy_block_no').autocomplete({
    'source': function(request, response) {
      if (request) {
        $.ajax({
          url: 'index.php?route=sale/speedy/getBlocks&token=<?php echo $token; ?>',
          dataType: 'json',
          data: {
            term: function() { return $('#speedy_block_no').val(); },
            city_id: function() { return $('#speedy_city_id').val(); },
            abroad: $('#abroad').val()
          },
          success: function(data) {
            if (data.error) {
              $('#speedy_block_no').val('');
              alert(data.error);
            } else {
              if ($('#speedy_city_nomenclature').val() == 'FULL') {
                if (data.length) {
                  response($.map(data, function(item) {
                    return {
                      label: item['label'],
                      value: item['value']
                    }
                  }));
                }
              } else {
                response($.map(data, function(item) {
                  return {
                    label: item['label'],
                    value: item['value']
                  }
                }));
              }
            }
          },
          error: function(xhr, ajaxOptions, thrownError) {
            //alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
          }
        });
      }
    },
    'select': function(item) {
      if (item) {
        $('#speedy_block_no').val(item.value);
      }
    }
  });

  $('#speedy_block_no').blur(function() {
    if (!$(this).val()) {
      $('#speedy_block_no').val('');
    }
  });

  $('#speedy_country').autocomplete({
    'source': function(request, response) {
      if (request) {
        $.ajax({
          url: 'index.php?route=sale/speedy/getCountries&token=<?php echo $token; ?>',
          dataType: 'json',
          type: 'get',
          data: {
            term: request,
            abroad: $('#abroad').val()
          },
          success: function(json) {
            if ($('#speedy_country').is(":focus")) {
              response($.map(json, function(item) {
                return {
                  label:                item['name'],
                  value:                item['name'],
                  id:                   item['id'],
                  nomenclature:         item['nomenclature'],
                  required_state:       item['required_state'],
                  required_postcode:    item['required_postcode'],
                  active_currency_code: item['active_currency_code'],
                  address_nomenclature: item['address_nomenclature'],
                }
              }));
            }
          }
        });
      }
    },
    'select': function(item) {
      if (item) {
        $('#abroad_speedy_state, #abroad_speedy_postcode').removeClass('required');
        speedy_country = item.value;
        $('#speedy_country').val(item.value);
        $('#speedy_country_id').val(item.id);
        $('#speedy_country_nomenclature').val(item.nomenclature);
        $('#required_state').val(item.required_state);
        $('#required_postcode').val(item.required_postcode);
        $('#speedy_active_currency_code').val(item.active_currency_code);

        if (item.address_nomenclature) {
          $('#country_has_address_nomenclature').show();
          $('#country_has_no_address_nomenclature').hide();
        } else {
          $('#country_has_address_nomenclature').hide();
          $('#country_has_no_address_nomenclature').show();
        }

        if (!item.active_currency_code) {
          $('#speedy_cod_container').hide();
          $('#speedy_total_container').hide();
          $('#speedy_option_before_payment_container').hide();
          $('#speedy_cod_no').click();
          $('#speedy_cod_status').val(0);
        } else {
          $('#speedy_cod_container').show();
          $('#speedy_total_container').show();
          $('#speedy_option_before_payment_container').show();
          $('#speedy_cod_container').show();
          $('#speedy_cod_status').val(1);
        }

        if (item.required_state) {
          $('#abroad_speedy_state').addClass('required');
        } else {
          $('#abroad_speedy_state').removeClass('required');
        }

        if (item.required_postcode) {
          $('#abroad_speedy_postcode').addClass('required');
        } else {
          $('#abroad_speedy_postcode').removeClass('required');
        }
      }
    },
    'change': function(item) {
      if(!item) {
        $('#to_office').hide();
        $('[name=to_office][value=0]').trigger('click');

        $('#speedy_country').val('');
        $('#speedy_country_id').val('');
        $('#speedy_country_nomenclature').val('');
        $('#speedy_state').val('');
        $('#speedy_state_id').val('');
        $('#speedy_city').val('');
        $('#speedy_city_id').val('');
        $('#speedy_city_nomenclature').val('');
        $('#speedy_quarter').val('');
        $('#speedy_quarter_id').val('');
        $('#speedy_street').val('');
        $('#speedy_street_id').val('');
        $('#speedy_street_no').val('');
        $('#speedy_street_type').val('');
        $('[for="speedy_street"] span').text('');
        $('#speedy_block_no').val('');
        $('#speedy_entrance_no').val('');
        $('#speedy_floor_no').val('');
        $('#speedy_apartment_no').val('');
        $('#speedy_note').val('');
        $('#speedy_postcode').val('');
      }
    }
  });

  $('#speedy_country').blur(function() {
    if ($(this).val() != speedy_country) {
      $('#to_office').hide();
      $('[name=to_office][value=0]').trigger('click');

      $(this).val('');
      $('#speedy_country_id').val('');
      $('#speedy_country_nomenclature').val('');
      $('#speedy_state').val('');
      $('#speedy_state_id').val('');
      $('#speedy_city').val('');
      $('#speedy_city_id').val('');
      $('#speedy_city_nomenclature').val('');
      $('#speedy_quarter').val('');
      $('#speedy_quarter_id').val('');
      $('#speedy_street').val('');
      $('#speedy_street_id').val('');
      $('#speedy_street_no').val('');
      $('#speedy_street_type').val('');
      $('[for="speedy_street"] span').text('');
      $('#speedy_block_no').val('');
      $('#speedy_entrance_no').val('');
      $('#speedy_floor_no').val('');
      $('#speedy_apartment_no').val('');
      $('#speedy_note').val('');
      $('#speedy_postcode').val('');
    }
  });

  $('#speedy_state').autocomplete({
    'source': function(request, response) {
      if (request) {
        $.ajax({
          url: 'index.php?route=sale/speedy/getStates&token=<?php echo $token; ?>',
          dataType: 'json',
          type: 'get',
          data: {
            term: request,
            country_id: $('#speedy_country_id').val()
          },
          success: function(json) {
            if ($('#speedy_state').is(":focus")) {
              response($.map(json, function(item) {
                return {
                  label:        item['name'],
                  value:        item['name'],
                  id:           item['id']
                }
              }));
            }
          }
        });
      }
    },
    'select': function(item) {
      if (item) {
        speedy_state = item.value;
        $('#speedy_state').val(item.value);
        $('#speedy_state_id').val(item.id);
      }
    },
    'change': function(item) {
      if(!item) {
        $('#speedy_state').val('');
        $('#speedy_state_id').val('');
      }
    }
  });

  $('#speedy_state').blur(function() {
    if ($(this).val() != speedy_state) {
      $(this).val('');
      $('#speedy_state_id').val('');
    }
  });

  $('#form-speedy input').keypress(function(event){
    if (($('#abroad').val() == 1) && event.key.match(/[а-яА-я]/)) {
      event.preventDefault();
      alert('<?php echo $error_cyrillic; ?>');
    }
  });

  $('#speedy_office_id').on('change', function() {
    $('#office_name').val($('#speedy_office_id option:selected').text());
  });

  $('#to_office input[name=to_office]').on('change', function () {
    hideOffices(this);

    if ($(this).attr('data-is-apt') == 1) {
        $('#speedy_office_id option[value=0]').text('<?php echo $text_select_apt; ?>');
    } else {
        $('#speedy_office_id option[value=0]').text('<?php echo $text_select_office; ?>');
    }

    $('#speedy_office_id').val(0);
  });

  function hideOffices(speedy_checkbox) {
    $('#is_apt').val($(speedy_checkbox).attr('data-is-apt'));

    if ($(speedy_checkbox).val() == 1) {
        $('#speedy_office_id option').each(function() {
            if ($(this).val() == 0) {
                return;
            }

            if (($(this).attr('data-is-apt') == 1 && $(speedy_checkbox).attr('data-is-apt') != 1)
                || ($(this).attr('data-is-apt') != 1 && $(speedy_checkbox).attr('data-is-apt') == 1)
            ) {
                $(this).hide();
            } else {
                $(this).show();
            }
        });

        $('#speedy_quarter_container, #speedy_street_container, #speedy_block_no_container, #speedy_note_container').hide();
        $('#speedy_office_container').show();
      } else {
        $('#speedy_quarter_container, #speedy_street_container, #speedy_block_no_container, #speedy_note_container').show();
        $('#speedy_office_container').hide();
      }
  }

  hideOffices($('#to_office input[name=to_office]:checked'));
});
<?php if ($ignore_obp) { ?>
$('#speedy_option_before_payment').change(function() {
    if ($(this).val() == 'test') {
        $('#speedy_shipping_to_apt').parent().find('span').text('<?php echo $text_to_apt_ignore_obp_test; ?>');
    } else if ($(this).val() == 'open') {
        $('#speedy_shipping_to_apt').parent().find('span').text('<?php echo $text_to_apt_ignore_obp_open; ?>');
    } else {
        $('#speedy_shipping_to_apt').parent().find('span').text('<?php echo $text_to_apt; ?>');
    }
});
<?php } ?>
$('input[name=shipping_method]').change(function() {
  if($(this).attr('data-shipping_method_id') == 500) { // id for speedy POST method
    $('#speedy_count').parent().parent().hide();
    $('#parcels_size').parent().parent().hide();
  } else {
    $('#speedy_count').parent().parent().show();
    $('#parcels_size').parent().parent().show();
  }
});
//--></script>
<?php echo $footer; ?>