<?php
class ModelShippingSpeedy extends Model {
	public function createTables() {
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "speedy_address` (
		  `address_id` INT(11) NOT NULL,
		  `customer_id` INT(11) NOT NULL,
		  `postcode` VARCHAR(10) NOT NULL DEFAULT '',
		  `city` VARCHAR(255) NOT NULL DEFAULT '',
		  `city_id` INT(11) NOT NULL DEFAULT '0',
		  `city_nomenclature` VARCHAR(15) NOT NULL DEFAULT '',
		  `to_office` TINYINT(1) NOT NULL DEFAULT '0',
		  `office_id` INT(11) NOT NULL DEFAULT '0',
		  `quarter` VARCHAR(255) NOT NULL DEFAULT '',
		  `quarter_id` INT(11) NOT NULL DEFAULT '0',
		  `street` VARCHAR(255) NOT NULL DEFAULT '',
		  `street_id` INT(11) NOT NULL DEFAULT '0',
		  `street_no` VARCHAR(255) NOT NULL DEFAULT '',
		  `block_no` VARCHAR(255) NOT NULL DEFAULT '',
		  `entrance_no` VARCHAR(255) NOT NULL DEFAULT '',
		  `floor_no` VARCHAR(255) NOT NULL DEFAULT '',
		  `apartment_no` VARCHAR(255) NOT NULL DEFAULT '',
		  `note` VARCHAR(255) NOT NULL DEFAULT '',
		  KEY `address_id` (`address_id`),
		  KEY `customer_id` (`customer_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8");

		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "speedy_order` (
		  `speedy_order_id` INT(11) NOT NULL AUTO_INCREMENT,
		  `order_id` INT(11) NOT NULL DEFAULT '0',
		  `bol_id` VARCHAR(15) NOT NULL,
		  `data` TEXT NOT NULL,
		  `date_created` DATETIME NOT NULL,
		  `courier` TINYINT(1) NOT NULL DEFAULT '0',
		  PRIMARY KEY (`speedy_order_id`),
		  KEY `order_id` (`order_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8");
	}

	public function deleteTables() {
		$this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . "speedy_address`");
		$this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . "speedy_order`");
		$this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . "speedy_product_settings`");
		$this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . "speedy_table_rate`");
	}

	public function importFilePrice($data) {
		$this->db->query("TRUNCATE `" . DB_PREFIX . "speedy_table_rate`");

		foreach ($data as $row) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "speedy_table_rate SET service_id = '" . (int)$row['service_id'] . "', take_from_office = '" . (int)$row['take_from_office'] . "', weight = '" . (float)$row['weight'] . "', order_total = '" . (float)$row['order_total'] . "', price_without_vat = '" . (float)$row['price_without_vat'] . "'");
		}
	}

	public function updateTablesV220() { // for Abroad Shipping
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `country` VARCHAR(255) NOT NULL DEFAULT '' AFTER `note`");
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `country_id` INT(11) NOT NULL DEFAULT '0' AFTER `country`");
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `country_nomenclature` VARCHAR(15) NOT NULL DEFAULT '' AFTER `country_id`");
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `state` VARCHAR(255) NOT NULL DEFAULT '' AFTER `country_nomenclature`");
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `state_id` VARCHAR(50) NOT NULL DEFAULT '' AFTER `state`");
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `required_state` TINYINT(1) NOT NULL DEFAULT '0' AFTER `state_id`");
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `required_postcode` TINYINT(1) NOT NULL DEFAULT '0' AFTER `required_state`");
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `address_1` VARCHAR(255) NOT NULL DEFAULT '' AFTER `required_postcode`");
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `address_2` VARCHAR(255) NOT NULL DEFAULT '' AFTER `address_1`");
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "speedy_address` ADD `abroad` TINYINT(1) NOT NULL DEFAULT '0' AFTER `address_2`");

		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "speedy_table_rate` (
		  `service_id` INT(11) NOT NULL,
		  `take_from_office` TINYINT(1) NOT NULL,
		  `weight` DECIMAL(15,4) NOT NULL,
		  `order_total`  DECIMAL(15,4) NOT NULL,
		  `price_without_vat` DECIMAL(15,4) NOT NULL
		) ENGINE=MyISAM DEFAULT CHARSET=utf8");
	}

	public function updateTablesV372() {
		$this->addColumn('operation_code', 'speedy_order', "INT(11) NOT NULL");
		$this->addColumn('delivery_info', 'speedy_order', "VARCHAR(255) NULL");
	}

	public function updateTablesV373() {
		$this->addColumn('is_apt', 'speedy_address', "TINYINT(1) NOT NULL DEFAULT '0'");
	}

	public function updateTablesV501() {
		$this->addColumn('street_type', 'speedy_address', "VARCHAR(255) NOT NULL DEFAULT ''", 'street');
	}

	public function addColumn($columnName, $tableName, $specifications, $after = false) {
		if (!$this->hasColumn($columnName, $tableName)) {
			$sql = "ALTER TABLE `" . DB_PREFIX . $tableName . "` ADD `$columnName` $specifications ";
			if ($after) {
				$sql .= " AFTER `$after`";
			}
			$this->db->query($sql);
		}
	}

	public function hasColumn($columnName, $tableName) {
		$query = $this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . $tableName . "` WHERE FIELD = '$columnName'");
		return boolval($query->num_rows);
	}
}
?>