<?php

class ControllerShippingSpeedy extends Controller {

	private $error = array();
	const MIN_PHP_VERSION_REQUIRED = '5.6';
	const MIN_MySQL_VERSION_REQUIRED = '5.0';

	public function index() {
		$this->load->language('shipping/speedy');
		$this->load->language('catalog/speedy');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->document->addStyle('./view/javascript/speedy/css/speedy.css');

		if (!$this->config->get('speedy_updated_v220')) { //for Abroad Shipping
			$this->updateV220();
		}

		if (!$this->config->get('speedy_updated_v372')) { // operation code
			$this->updateV372();
		}

		if (!$this->config->get('speedy_updated_v373')) { // is_api code
			$this->updateV373();
		}

		if (!$this->config->get('speedy_updated_v501')) { // street_type
			$this->updateV501();
		}

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
			$new_user = $this->request->post['speedy_username'] != $this->config->get('speedy_username');
			if (!$new_user && ($this->request->post['speedy_password'] == $this->language->get('hide_pass') || $this->config->get('speedy_password'))) {
				if (!$this->request->post['pass_changed'] || $this->request->post['speedy_password'] == $this->config->get('speedy_password')) {
					$this->request->post['speedy_password'] = $this->config->get('speedy_password');
				} else {
					$this->request->post['speedy_password'] = '';
				}
			}
		}

		require_once(DIR_SYSTEM . 'library/speedy.php');
		$speedy = new Speedy($this->registry);
		if ($speedy->getError() && ($this->request->server['REQUEST_METHOD'] == 'POST')) {
			$this->error['warning'] = $speedy->getError();
		}

		$this->load->model('setting/setting');
		$this->load->model('shipping/speedy');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->request->post['speedy_updated_v220'] = true; //for Abroad Shipping
			$this->request->post['speedy_updated_v372'] = true; //operation code
			$this->request->post['speedy_updated_v373'] = true; //is_apt column
			$this->request->post['speedy_updated_v501'] = true; //street_type column

			if (isset($this->request->post['speedy_default_weight'])) {
				$this->request->post['speedy_default_weight'] = str_replace(',', '.', $this->request->post['speedy_default_weight']);
			}

			if (!$speedy->isAvailableMoneyTransfer()) {
				$this->request->post['speedy_money_transfer'] = 0;
			}

			$this->model_setting_setting->editSetting('speedy', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			if (version_compare(VERSION, '2.3', '>')) {
				$this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=shipping', true));
			} else {
				$this->response->redirect($this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'));
			}
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_select_all'] = $this->language->get('text_select_all');
		$data['text_unselect_all'] = $this->language->get('text_unselect_all');
		$data['text_filename'] = $this->language->get('text_filename');
		$data['text_loading'] = $this->language->get('text_loading');
		$data['text_sevice_id'] = $this->language->get('text_sevice_id');
		$data['text_package_weight'] = $this->language->get('text_package_weight');
		$data['text_none'] = $this->language->get('text_none');
		$data['text_client_id'] = $this->language->get('text_client_id');
		$data['text_label_requirements'] = $this->language->get('text_label_requirements');
		$data['text_requirements'] = $this->language->get('text_requirements');
		$data['text_min_reqired'] = $this->language->get('text_min_reqired');
		$data['text_current'] = $this->language->get('text_current');
		$data['text_result'] = $this->language->get('text_result');
		$data['text_speedy_status'] = $this->language->get('text_speedy_status');
		$data['text_opencart_status'] = $this->language->get('text_opencart_status');

		$data['entry_version'] = $this->language->get('entry_version');
		$data['entry_server_address'] = $this->language->get('entry_server_address');
		$data['entry_username'] = $this->language->get('entry_username');
		$data['entry_password'] = $this->language->get('entry_password');
		$data['entry_name'] = $this->language->get('entry_name');
		$data['entry_telephone'] = $this->language->get('entry_telephone');
		$data['entry_workingtime_end'] = $this->language->get('entry_workingtime_end');
		$data['entry_allowed_methods'] = $this->language->get('entry_allowed_methods');
		$data['entry_client_id'] = $this->language->get('entry_client_id');
		$data['entry_pricing'] = $this->language->get('entry_pricing');
		$data['entry_fixed_price'] = $this->language->get('entry_fixed_price');
		$data['entry_free_shipping_total'] = $this->language->get('entry_free_shipping_total');
		$data['entry_free_method_city'] = $this->language->get('entry_free_method_city');
		$data['entry_free_method_intercity'] = $this->language->get('entry_free_method_intercity');
		$data['entry_free_method_international'] = $this->language->get('entry_free_method_international');
		$data['entry_default_weight'] = $this->language->get('entry_default_weight');
		$data['entry_packing'] = $this->language->get('entry_packing');
		$data['entry_label_printer'] = $this->language->get('entry_label_printer');
		$data['entry_additional_copy_for_sender'] = $this->language->get('entry_additional_copy_for_sender');
		$data['entry_insurance'] = $this->language->get('entry_insurance');
		$data['entry_fragile'] = $this->language->get('entry_fragile');
		$data['entry_from_office'] = $this->language->get('entry_from_office');
		$data['entry_office'] = $this->language->get('entry_office');
		$data['entry_check_office_work_day'] = $this->language->get('entry_check_office_work_day');
		$data['entry_one_field_address'] = $this->language->get('entry_one_field_address');
		$data['entry_taking_date'] = $this->language->get('entry_taking_date');
		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_order_status_update'] = $this->language->get('entry_order_status_update');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['entry_options_before_payment'] = $this->language->get('entry_options_before_payment');
		$data['entry_return_payer_type'] = $this->language->get('entry_return_payer_type');
		$data['entry_return_package_city_service_id'] = $this->language->get('entry_return_package_city_service_id');
		$data['entry_return_package_intercity_service_id'] = $this->language->get('entry_return_package_intercity_service_id');
		$data['entry_ignore_obp'] = $this->language->get('entry_ignore_obp');
		$data['entry_return_voucher'] = $this->language->get('entry_return_voucher');
		$data['entry_return_voucher_city_service_id'] = $this->language->get('entry_return_voucher_city_service_id');
		$data['entry_return_voucher_intercity_service_id'] = $this->language->get('entry_return_voucher_intercity_service_id');
		$data['entry_return_voucher_payer_type'] = $this->language->get('entry_return_voucher_payer_type');
		$data['entry_return_voucher_period'] = $this->language->get('entry_return_voucher_period');
		$data['entry_money_transfer'] = $this->language->get('entry_money_transfer');
		$data['entry_courier_sevice'] = $this->language->get('entry_courier_sevice');
		$data['entry_saturday_delivery'] = $this->language->get('entry_saturday_delivery');
		$data['entry_card_payment_forbidden'] = $this->language->get('entry_card_payment_forbidden');
		$data['entry_administration_fee'] = $this->language->get('entry_administration_fee');
		$data['entry_cod_with_shipping_price'] = $this->language->get('entry_cod_with_shipping_price');
		$data['entry_special_delivery_id'] = $this->language->get('entry_special_delivery_id');
		$data['entry_speedy_iban'] = $this->language->get('entry_speedy_iban');
		$data['entry_speedy_accountHolder'] = $this->language->get('entry_speedy_accountHolder');
		$data['entry_speedy_payment_method'] = $this->language->get('entry_speedy_payment_method');
		$data['entry_select'] = $this->language->get('entry_select');

		$data['entry_bank'] = $this->language->get('entry_bank');

		$data['entry_cash'] = $this->language->get('entry_cash');
		$data['entry_plik'] = $this->language->get('entry_plik');
		$data['entry_klient'] = $this->language->get('entry_klient');
		$data['entry_izprashtane'] = $this->language->get('entry_izprashtane');
		$data['entry_uslugi'] = $this->language->get('entry_uslugi');
		$data['entry_plashtane'] = $this->language->get('entry_plashtane');
		$data['entry_dopalnitelni'] = $this->language->get('entry_dopalnitelni');

		$data['entry_markiray'] = $this->language->get('entry_markiray');
		$data['entry_demarkiray'] = $this->language->get('entry_demarkiray');
		$data['entry_showall'] = $this->language->get('entry_showall');
		$data['entry_shownotall'] = $this->language->get('entry_shownotall');

		$data['entry_vkluchen'] = $this->language->get('entry_vkluchen');
		$data['entry_izkluchen'] = $this->language->get('entry_izkluchen');

		$data['help_fragile'] = $this->language->get('help_fragile');
		$data['help_from_office'] = $this->language->get('help_from_office');
		$data['help_documents'] = $this->language->get('help_documents');
		$data['help_money_transfer'] = $this->language->get('help_money_transfer');
		$data['help_courier_sevice'] = $this->language->get('help_courier_sevice');
		$data['help_filename'] = $this->language->get('help_filename');
		$data['help_weight'] = $this->language->get('help_weight');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['button_testcredentials'] = $this->language->get('check_credentials_btn_label');
		$data['button_upload'] = $this->language->get('button_upload');

		$data['operation_delivered'] = $this->language->get('operation_delivered');
		$data['operation_delivered_back_to_sender'] = $this->language->get('operation_delivered_back_to_sender');
		$data['operation_destroyed'] = $this->language->get('operation_destroyed');
		$data['operation_theft_burglary'] = $this->language->get('operation_theft_burglary');
		$data['operation_canceled'] = $this->language->get('operation_canceled');
		$data['operation_administrative_closure'] = $this->language->get('operation_administrative_closure');

		$data['column_speedy_XS'] = $this->language->get('column_speedy_XS');
		$data['column_speedy_S'] = $this->language->get('column_speedy_S');
		$data['column_speedy_M'] = $this->language->get('column_speedy_M');
		$data['column_speedy_L'] = $this->language->get('column_speedy_L');
		$data['column_speedy_XL'] = $this->language->get('column_speedy_XL');
		$data['alert_enter_pass_again'] = $this->language->get('alert_enter_pass_again');

		$data['token'] = $this->session->data['token'];

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['username'])) {
			$data['error_username'] = $this->error['username'];
		} else {
			$data['error_username'] = '';
		}

		$data['error_username_credentials'] = $this->language->get('error_username_credentials_chk');
		$data['error_password_credentials'] = $this->language->get('error_password_credentials_chk');

		if (isset($this->error['password'])) {
			$data['error_password'] = $this->error['password'];
		} else {
			$data['error_password'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		if (isset($this->error['telephone'])) {
			$data['error_telephone'] = $this->error['telephone'];
		} else {
			$data['error_telephone'] = '';
		}

		if (isset($this->error['client_id'])) {
			$data['error_client_id'] = $this->error['client_id'];
		} else {
			$data['error_client_id'] = '';
		}

		if (isset($this->error['default_weight'])) {
			$data['error_default_weight'] = $this->error['default_weight'];
		} else {
			$data['error_default_weight'] = '';
		}

		if (isset($this->error['allowed_methods'])) {
			$data['error_allowed_methods'] = $this->error['allowed_methods'];
		} else {
			$data['error_allowed_methods'] = '';
		}

		if (isset($this->error['free_method_international'])) {
			$data['error_free_method_international'] = $this->error['free_method_international'];
		} else {
			$data['error_free_method_international'] = '';
		}

		if (isset($this->error['taking_date'])) {
			$data['error_taking_date'] = $this->error['taking_date'];
		} else {
			$data['error_taking_date'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => false
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_shipping'),
			'href' => $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => ' :: '
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('shipping/speedy', 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => ' :: '
		);

		$data['action'] = $this->url->link('shipping/speedy', 'token=' . $this->session->data['token'], 'SSL');

		if (version_compare(VERSION, '2.3', '>')) {
			$data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=shipping', true);
		} else {
			$data['cancel'] = $this->url->link('extension/shipping', 'token=' . $this->session->data['token'], 'SSL');
		}

		// Check requirments
		$php_version = preg_replace('/^([0-9\.]+).*/', '$1', phpversion());
		$mysql_version = $this->db->query("SELECT VERSION() as mysql_version");
		$mysql_version = preg_replace('/^([0-9\.]+).*/', '$1', $mysql_version->row['mysql_version']);

		$php_version_fulfilled = version_compare($php_version, self::MIN_PHP_VERSION_REQUIRED, '>=');
		$mysql_version_fulfilled = version_compare($mysql_version, self::MIN_MySQL_VERSION_REQUIRED, '>=');

		$data['requirements'] = array(
			array(
				'name' => $this->language->get('text_php_version'),
				'required' => self::MIN_PHP_VERSION_REQUIRED,
				'current' => $php_version,
				'is_success' => $php_version_fulfilled,
				'result' => $php_version_fulfilled ? $this->language->get('text_fulfilled') : $this->language->get('text_not_fulfilled')
			),
			array(
				'name' => $this->language->get('text_mysql_version'),
				'required' => self::MIN_MySQL_VERSION_REQUIRED,
				'current' => $mysql_version,
				'is_success' => $mysql_version_fulfilled,
				'result' => $mysql_version_fulfilled ? $this->language->get('text_fulfilled') : $this->language->get('text_not_fulfilled')
			),
		);

		if (!Speedy::NEW_API) {
			$soap_fulfilled = class_exists('SOAPClient');

			$data['requirements'][] = array(
				'name' => $this->language->get('text_soap_extension'),
				'required' => '-',
				'current' => $soap_fulfilled ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
				'is_success' => $soap_fulfilled,
				'result' => $soap_fulfilled ? $this->language->get('text_fulfilled') : $this->language->get('text_not_fulfilled')
			);
		}

		if (Speedy::NEW_API) {
			$data['speedy_server_address'] = Speedy\Curl::BASE_URL;
		} else {
			$data['speedy_server_address'] = Speedy::SERVER_ADDRESS;
		}

		if (isset($this->request->post['speedy_username'])) {
			$data['speedy_username'] = $this->request->post['speedy_username'];
		} else {
			$data['speedy_username'] = $this->config->get('speedy_username');
		}

		if (isset($this->request->post['speedy_password'])) {
			$data['speedy_password'] = $this->request->post['speedy_password'];
		} else {
			if ($this->config->get('speedy_password')) {
				$data['speedy_password'] = $this->language->get('hide_pass');
			} else {
				$data['speedy_password'] = '';
			}
		}

		if (isset($this->request->post['speedy_name'])) {
			$data['speedy_name'] = $this->request->post['speedy_name'];
		} else {
			$data['speedy_name'] = $this->config->get('speedy_name');
		}

		if (isset($this->request->post['speedy_telephone'])) {
			$data['speedy_telephone'] = $this->request->post['speedy_telephone'];
		} else {
			$data['speedy_telephone'] = $this->config->get('speedy_telephone');
		}

		if (isset($this->request->post['speedy_workingtime_end_hour'])) {
			$data['speedy_workingtime_end_hour'] = $this->request->post['speedy_workingtime_end_hour'];
		} else {
			$data['speedy_workingtime_end_hour'] = $this->config->get('speedy_workingtime_end_hour');
		}

		if (isset($this->request->post['speedy_workingtime_end_min'])) {
			$data['speedy_workingtime_end_min'] = $this->request->post['speedy_workingtime_end_min'];
		} else {
			$data['speedy_workingtime_end_min'] = $this->config->get('speedy_workingtime_end_min');
		}

		if (isset($this->request->post['speedy_allowed_methods'])) {
			$data['speedy_allowed_methods'] = $this->request->post['speedy_allowed_methods'];
		} elseif ($this->config->get('speedy_allowed_methods') && $this->request->server['REQUEST_METHOD'] != 'POST') {
			$data['speedy_allowed_methods'] = $this->config->get('speedy_allowed_methods');
		} else {
			$data['speedy_allowed_methods'] = array();
		}

		if (isset($this->request->post['speedy_client_id'])) {
			$data['speedy_client_id'] = $this->request->post['speedy_client_id'];
		} else {
			$data['speedy_client_id'] = $this->config->get('speedy_client_id');
		}

		if (isset($this->request->post['speedy_pricing'])) {
			$data['speedy_pricing'] = $this->request->post['speedy_pricing'];
		} else {
			$data['speedy_pricing'] = $this->config->get('speedy_pricing');
		}

		if (isset($this->request->post['speedy_option_before_payment'])) {
			$data['speedy_option_before_payment'] = $this->request->post['speedy_option_before_payment'];
		} else {
			$data['speedy_option_before_payment'] = $this->config->get('speedy_option_before_payment');
		}

		if (isset($this->request->post['speedy_return_payer_type'])) {
			$data['speedy_return_payer_type'] = $this->request->post['speedy_return_payer_type'];
		} else {
			$data['speedy_return_payer_type'] = $this->config->get('speedy_return_payer_type');
		}

		if (isset($this->request->post['speedy_return_package_city_service_id'])) {
			$data['speedy_return_package_city_service_id'] = $this->request->post['speedy_return_package_city_service_id'];
		} else {
			$data['speedy_return_package_city_service_id'] = $this->config->get('speedy_return_package_city_service_id');
		}

		if (isset($this->request->post['speedy_return_package_intercity_service_id'])) {
			$data['speedy_return_package_intercity_service_id'] = $this->request->post['speedy_return_package_intercity_service_id'];
		} else {
			$data['speedy_return_package_intercity_service_id'] = $this->config->get('speedy_return_package_intercity_service_id');
		}

		if (isset($this->request->post['speedy_ignore_obp'])) {
			$data['speedy_ignore_obp'] = $this->request->post['speedy_ignore_obp'];
		} else {
			$data['speedy_ignore_obp'] = $this->config->get('speedy_ignore_obp');
		}

		if (isset($this->request->post['speedy_return_voucher'])) {
			$data['speedy_return_voucher'] = $this->request->post['speedy_return_voucher'];
		} else {
			$data['speedy_return_voucher'] = $this->config->get('speedy_return_voucher');
		}

		if (isset($this->request->post['speedy_include_shipping_price'])) {
			$data['speedy_include_shipping_price'] = $this->request->post['speedy_include_shipping_price'];
		} else {
			$data['speedy_include_shipping_price'] = $this->config->get('speedy_include_shipping_price');
		}

		if (isset($this->request->post['speedy_return_voucher_city_service_id'])) {
			$data['speedy_return_voucher_city_service_id'] = $this->request->post['speedy_return_voucher_city_service_id'];
		} else {
			$data['speedy_return_voucher_city_service_id'] = $this->config->get('speedy_return_voucher_city_service_id');
		}

		if (isset($this->request->post['speedy_return_voucher_intercity_service_id'])) {
			$data['speedy_return_voucher_intercity_service_id'] = $this->request->post['speedy_return_voucher_intercity_service_id'];
		} else {
			$data['speedy_return_voucher_intercity_service_id'] = $this->config->get('speedy_return_voucher_intercity_service_id');
		}

		if (isset($this->request->post['speedy_return_voucher_period'])) {
			$data['speedy_return_voucher_period'] = $this->request->post['speedy_return_voucher_period'];
		} else {
			$data['speedy_return_voucher_period'] = $this->config->get('speedy_return_voucher_period');
		}

		if (isset($this->request->post['speedy_return_voucher_payer_type'])) {
			$data['speedy_return_voucher_payer_type'] = $this->request->post['speedy_return_voucher_payer_type'];
		} else {
			$data['speedy_return_voucher_payer_type'] = $this->config->get('speedy_return_voucher_payer_type');
		}

		if (isset($this->request->post['speedy_fixed_price'])) {
			$data['speedy_fixed_price'] = $this->request->post['speedy_fixed_price'];
		} else {
			$data['speedy_fixed_price'] = $this->config->get('speedy_fixed_price');
		}

		if (isset($this->request->post['speedy_free_shipping_total'])) {
			$data['speedy_free_shipping_total'] = $this->request->post['speedy_free_shipping_total'];
		} else {
			$data['speedy_free_shipping_total'] = $this->config->get('speedy_free_shipping_total');
		}

		if (isset($this->request->post['speedy_free_method_city'])) {
			$data['speedy_free_method_city'] = $this->request->post['speedy_free_method_city'];
		} else {
			$data['speedy_free_method_city'] = $this->config->get('speedy_free_method_city');
		}

		if (isset($this->request->post['speedy_free_method_intercity'])) {
			$data['speedy_free_method_intercity'] = $this->request->post['speedy_free_method_intercity'];
		} else {
			$data['speedy_free_method_intercity'] = $this->config->get('speedy_free_method_intercity');
		}

		if (isset($this->request->post['speedy_free_method_international'])) {
			$data['speedy_free_method_international'] = $this->request->post['speedy_free_method_international'];
		} elseif ($this->config->get('speedy_free_method_international') && $this->request->server['REQUEST_METHOD'] != 'POST') {
			$data['speedy_free_method_international'] = $this->config->get('speedy_free_method_international');
		} else {
			$data['speedy_free_method_international'] = array();
		}

		if (isset($this->request->post['speedy_default_weight'])) {
			$data['speedy_default_weight'] = $this->request->post['speedy_default_weight'];
		} else {
			$data['speedy_default_weight'] = $this->config->get('speedy_default_weight');
		}

		if (isset($this->request->post['speedy_packing'])) {
			$data['speedy_packing'] = $this->request->post['speedy_packing'];
		} else {
			$data['speedy_packing'] = $this->config->get('speedy_packing');
		}

		if (isset($this->request->post['speedy_label_printer'])) {
			$data['speedy_label_printer'] = $this->request->post['speedy_label_printer'];
		} else {
			$data['speedy_label_printer'] = $this->config->get('speedy_label_printer');
		}

		if (isset($this->request->post['speedy_additional_copy_for_sender'])) {
			$data['speedy_additional_copy_for_sender'] = $this->request->post['speedy_additional_copy_for_sender'];
		} else {
			$data['speedy_additional_copy_for_sender'] = $this->config->get('speedy_additional_copy_for_sender');
		}

		if (isset($this->request->post['speedy_insurance'])) {
			$data['speedy_insurance'] = $this->request->post['speedy_insurance'];
		} else {
			$data['speedy_insurance'] = $this->config->get('speedy_insurance');
		}

		if (isset($this->request->post['speedy_fragile'])) {
			$data['speedy_fragile'] = $this->request->post['speedy_fragile'];
		} else {
			$data['speedy_fragile'] = $this->config->get('speedy_fragile');
		}

		if (isset($this->request->post['speedy_from_office'])) {
			$data['speedy_from_office'] = $this->request->post['speedy_from_office'];
		} else {
			$data['speedy_from_office'] = $this->config->get('speedy_from_office');
		}

		if (isset($this->request->post['speedy_office_id'])) {
			$data['speedy_office_id'] = $this->request->post['speedy_office_id'];
		} else {
			$data['speedy_office_id'] = $this->config->get('speedy_office_id');
		}

		if (isset($this->request->post['speedy_check_office_work_day'])) {
			$data['speedy_check_office_work_day'] = $this->request->post['speedy_check_office_work_day'];
		} else if ($this->config->get('speedy_check_office_work_day') != null) {
			$data['speedy_check_office_work_day'] = $this->config->get('speedy_check_office_work_day');
		} else {
			$data['speedy_check_office_work_day'] = 1;
		}

		if (isset($this->request->post['speedy_one_field_address'])) {
			$data['speedy_one_field_address'] = $this->request->post['speedy_one_field_address'];
		} else if ($this->config->get('speedy_one_field_address') != null) {
			$data['speedy_one_field_address'] = $this->config->get('speedy_one_field_address');
		} else {
			$data['speedy_one_field_address'] = 0;
		}

		if (isset($this->request->post['speedy_taking_date'])) {
			$data['speedy_taking_date'] = $this->request->post['speedy_taking_date'];
		} else {
			$data['speedy_taking_date'] = $this->config->get('speedy_taking_date');
		}

		if (isset($this->request->post['speedy_order_status_id'])) {
			$data['speedy_order_status_id'] = $this->request->post['speedy_order_status_id'];
		} else {
			$data['speedy_order_status_id'] = $this->config->get('speedy_order_status_id');
		}

		if (isset($this->request->post['speedy_geo_zone_id'])) {
			$data['speedy_geo_zone_id'] = $this->request->post['speedy_geo_zone_id'];
		} else {
			$data['speedy_geo_zone_id'] = $this->config->get('speedy_geo_zone_id');
		}

		if (isset($this->request->post['speedy_order_status_update'])) {
			$data['speedy_order_status_update'] = $this->request->post['speedy_order_status_update'];
		} else {
			$data['speedy_order_status_update'] = $this->config->get('speedy_order_status_update');
		}

		if (isset($this->request->post['speedy_final_statuses'])) {
			$data['speedy_final_statuses'] = $this->request->post['speedy_final_statuses'];
		} else if ($this->config->get('speedy_final_statuses')) {
			$data['speedy_final_statuses'] = $this->config->get('speedy_final_statuses');
		} else {
			$data['speedy_final_statuses'] = array();
		}

		if (!Speedy::NEW_API) {
			$data['entry_convertion_to_win1251'] = $this->language->get('entry_convertion_to_win1251');

			if (isset($this->request->post['speedy_convertion_to_win1251'])) {
				$data['speedy_convertion_to_win1251'] = $this->request->post['speedy_convertion_to_win1251'];
			} else {
				$data['speedy_convertion_to_win1251'] = $this->config->get('speedy_convertion_to_win1251');
			}
		}

		if (isset($this->request->post['speedy_status'])) {
			$data['speedy_status'] = $this->request->post['speedy_status'];
		} else {
			$data['speedy_status'] = $this->config->get('speedy_status');
		}

		if (isset($this->request->post['speedy_sort_order'])) {
			$data['speedy_sort_order'] = $this->request->post['speedy_sort_order'];
		} else {
			$data['speedy_sort_order'] = $this->config->get('speedy_sort_order');
		}

		if (isset($this->request->post['speedy_invoice_courier_sevice_as_text'])) {
			$data['speedy_invoice_courier_sevice_as_text'] = $this->request->post['speedy_invoice_courier_sevice_as_text'];
		} else {
			$data['speedy_invoice_courier_sevice_as_text'] = $this->config->get('speedy_invoice_courier_sevice_as_text');
		}

		if (isset($this->request->post['speedy_saturday_delivery'])) {
			$data['speedy_saturday_delivery'] = $this->request->post['speedy_saturday_delivery'];
		} else {
			$data['speedy_saturday_delivery'] = $this->config->get('speedy_saturday_delivery');
		}

		if (isset($this->request->post['speedy_card_payment_forbidden'])) {
			$data['speedy_card_payment_forbidden'] = $this->request->post['speedy_card_payment_forbidden'];
		} else {
			$data['speedy_card_payment_forbidden'] = $this->config->get('speedy_card_payment_forbidden');
		}

		if (isset($this->request->post['speedy_administrative_fee'])) {
			$data['speedy_administrative_fee'] = $this->request->post['speedy_administrative_fee'];
		} else {
			$data['speedy_administrative_fee'] = $this->config->get('speedy_administrative_fee');
		}

		if (isset($this->request->post['speedy_cod_with_shipping_price'])) {
			$data['speedy_cod_with_shipping_price'] = $this->request->post['speedy_cod_with_shipping_price'];
		} else {
			$data['speedy_cod_with_shipping_price'] = $this->config->get('speedy_cod_with_shipping_price');
		}

		if (isset($this->request->post['speedy_payment_method'])) {
			$data['speedy_payment_method'] = $this->request->post['speedy_payment_method'];
		} else {
			$data['speedy_payment_method'] = $this->config->get('speedy_payment_method');
		}

		if (isset($this->request->post['speedy_accountHolder'])) {
			$data['speedy_accountHolder'] = $this->request->post['speedy_accountHolder'];
		} else {
			$data['speedy_accountHolder'] = $this->config->get('speedy_accountHolder');
		}

		if (isset($this->request->post['speedy_iban'])) {
			$data['speedy_iban'] = $this->request->post['speedy_iban'];
		} else {
			$data['speedy_iban'] = $this->config->get('speedy_iban');
		}

		if (isset($this->request->post['speedy_special_delivery_id'])) {
			$data['speedy_special_delivery_id'] = $this->request->post['speedy_special_delivery_id'];
		} else {
			$data['speedy_special_delivery_id'] = $this->config->get('speedy_special_delivery_id');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		$data['services'] = $speedy->getServices($this->language->get('code'));

		$data['clients'] = $speedy->getListContractClients();

		$data['clientrequirements'] = $speedy->getListContractReq();

		$data['offices'] = $speedy->getOffices(null, null, $this->language->get('code'));

		$data['speedy_version'] = $speedy->version;

		if ($speedy->isAvailableMoneyTransfer()) {
			$data['available_money_transfer'] = true;

			if (isset($this->request->post['speedy_money_transfer'])) {
				$data['speedy_money_transfer'] = $this->request->post['speedy_money_transfer'];
			} else {
				$data['speedy_money_transfer'] = $this->config->get('speedy_money_transfer');
			}
		} else {
			$data['available_money_transfer'] = false;
			$data['speedy_money_transfer'] = false;
		}

		$data['pricings'] = array(
			'calculator' => $this->language->get('text_calculator'),
			'calculator_fixed' => $this->language->get('text_calculator_fixed'),
			'fixed' => $this->language->get('text_fixed_price'),
			'free' => $this->language->get('text_free_shipping'),
			'table_rate' => $this->language->get('text_table_rate'),
		);

		$data['options_before_payment'] = array(
			'no_option' => $this->language->get('text_no'),
			'test'      => $this->language->get('text_test_before_payment'),
			'open'      => $this->language->get('text_open_before_payment'),
		);

		$data['return_payer_types'] = array(
			0      => $this->language->get('text_sender'),
			1      => $this->language->get('text_receiver'),
		);

		$data['final_operation'] = Speedy::FINAL_OPERATION;

		$data['payer_types'] = array(
			ParamCalculation::PAYER_TYPE_SENDER   => $this->language->get('text_sender'),
			ParamCalculation::PAYER_TYPE_RECEIVER => $this->language->get('text_receiver'),
		);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('shipping/speedy.tpl', $data));
	}

	public function getContractRequirments() {
        //$url = Speedy\Curl::BASE_URL;
        $url = 'https://api.speedy.bg/v1/client/contract/info?username=999801&password=999801007';

        $ch = curl_init($url);

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);

        $response = curl_exec($ch);

   
        curl_close($ch);

        $data = json_decode($response, true);

        if ($data === null) {
            return false;
        }

        $requirementsArray = $data['specialDeliveryRequirements']['requirements'];

        return $requirementsArray;
    }

	public function checkcredentials($return = false) {
		
		$this->load->language('shipping/speedy');

		//$this->document->setTitle($this->language->get('heading_title'));

		require_once(DIR_SYSTEM . 'library/speedy.php');
		$speedy = new Speedy($this->registry);

		if (!$this->request->post['speedy_username'] || !$this->request->post['speedy_username']) {
			$this->response->setOutput(json_encode(array('error' => 1, 'message' => $this->language->get('incorrect_user_and_pass'))));

			return;
		}

		$username = $this->request->post['speedy_username'];
		$password = $this->request->post['speedy_password'];

		if ($password == $this->language->get('hide_pass') && !$this->request->post['pass_changed']) {
			$password = $this->config->get('speedy_password');
		}

		$isCredentialsCorrect = $speedy->checkCredentials($username, $password);

		if ($return) {
			return $isCredentialsCorrect;
		}

		if ($isCredentialsCorrect) {
			$this->response->setOutput(json_encode(array('ok' => 1, 'message' => $this->language->get('correct_user_and_pass'))));
		} else {
			$this->response->setOutput(json_encode(array('error' => 1, 'message' => $this->language->get('incorrect_user_and_pass'))));
		}
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'shipping/speedy')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['speedy_username']) {
			$this->error['username'] = $this->language->get('error_username');
		}

		if (!$this->checkcredentials(true)) {
			$this->request->post['shipping_speedy_password'] = '';
		}

		if (!$this->request->post['speedy_password']) {
			$this->error['password'] = $this->language->get('error_password');
		}

		if (!$this->request->post['speedy_name']) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if (!$this->request->post['speedy_telephone']) {
			$this->error['telephone'] = $this->language->get('error_telephone');
		}

		if (!$this->request->post['speedy_client_id']) {
			$this->error['client_id'] = $this->language->get('error_client_id');
		}

		if (!$this->request->post['speedy_default_weight']) {
			$this->error['default_weight'] = $this->language->get('error_default_weight');
		} elseif ($this->request->post['speedy_default_weight'] && !is_numeric($this->request->post['speedy_default_weight'])) {
			$this->error['default_weight'] = $this->language->get('error_invalid_number');
		}

		if (!isset($this->request->post['speedy_allowed_methods'])) {
			$this->error['allowed_methods'] = $this->language->get('error_allowed_methods');
		}

		if ($this->request->post['speedy_pricing'] == 'free' && !isset($this->request->post['speedy_free_method_international'])) {
			$this->error['free_method_international'] = $this->language->get('error_free_method_international');
		}

		if ($this->request->post['speedy_taking_date'] && !is_numeric($this->request->post['speedy_taking_date'])) {
			$this->error['taking_date'] = $this->language->get('error_invalid_number');
		}

		return !$this->error;
	}

	public function install() {
		$this->load->model('setting/setting');

		$shipping_data = array(
			'shipping_estimator' => 0,
			'shipping_status' => 1,
			'shipping_sort_order' => $this->config->get('shipping_sort_order')
		);

		$this->model_setting_setting->editSetting('shipping', $shipping_data);

		$cod_data = array(
			'cod_status' => 0
		);

		$this->model_setting_setting->editSetting('cod', $cod_data);

		$this->load->model('shipping/speedy');

		$this->model_shipping_speedy->createTables();

		@mail('modules.integration@speedy.bg', 'Speedy Shipping OpenCart 2 Module installed', HTTP_CATALOG . ' - ' . $this->config->get('config_name') . "\r\n" . 'version - ' . VERSION . "\r\n" . 'IP - ' . $this->request->server['REMOTE_ADDR'], 'MIME-Version: 1.0' . "\r\n" . 'Content-type: text/plain; charset=UTF-8' . "\r\n" . 'From: ' . $this->config->get('config_owner') . ' <' . $this->config->get('config_email') . '>' . "\r\n");
	}

	public function uninstall() {
		$this->load->model('shipping/speedy');

		$this->model_shipping_speedy->deleteTables();
	}

	private function updateV220() { //for Abroad Shipping
		$this->load->model('shipping/speedy');

		$this->model_shipping_speedy->updateTablesV220();

		$this->load->model('setting/setting');

		$data = $this->model_setting_setting->getSetting('speedy');
		$data['speedy_updated_v220'] = true;

		$this->model_setting_setting->editSetting('speedy', $data);
	}

	private function updateV372() { // operation code
		$this->load->model('shipping/speedy');

		$this->model_shipping_speedy->updateTablesV372();

		$this->load->model('setting/setting');

		$data = $this->model_setting_setting->getSetting('speedy');
		$data['speedy_updated_v372'] = true;

		$this->model_setting_setting->editSetting('speedy', $data);
	}

	private function updateV373() { // is_api code
		$this->load->model('shipping/speedy');

		$this->model_shipping_speedy->updateTablesV373();

		$this->load->model('setting/setting');

		$data = $this->model_setting_setting->getSetting('speedy');
		$data['speedy_updated_v373'] = true;

		$this->model_setting_setting->editSetting('speedy', $data);
	}

	private function updateV501() { // street_type
		$this->load->model('shipping/speedy');

		$this->model_shipping_speedy->updateTablesV501();

		$this->load->model('setting/setting');

		$data = $this->model_setting_setting->getSetting('speedy');
		$data['speedy_updated_v501'] = true;

		$this->model_setting_setting->editSetting('speedy', $data);
	}

	public function upload() {
		$this->load->language('shipping/speedy');
		$this->load->model('shipping/speedy');

		$json = array();

		// Check user has permission
		if (!$this->user->hasPermission('modify', 'shipping/speedy')) {
			$json['error'] = $this->language->get('error_permission');
		}


		if (!$json) {
			if (!empty($this->request->files['file']['name']) && is_file($this->request->files['file']['tmp_name'])) {
				// Sanitize the filename
				$filename = basename(html_entity_decode($this->request->files['file']['name'], ENT_QUOTES, 'UTF-8'));

				// Validate the filename length
				if ((utf8_strlen($filename) < 3) || (utf8_strlen($filename) > 128)) {
					$json['error'] = $this->language->get('error_filename');
				}

				// Allowed file extension types
				$allowed = array();

				$extension_allowed = preg_replace('~\r?\n~', "\n", 'csv');

				$filetypes = explode("\n", $extension_allowed);

				foreach ($filetypes as $filetype) {
					$allowed[] = trim($filetype);
				}

				if (!in_array(strtolower(substr(strrchr($filename, '.'), 1)), $allowed)) {
					$json['error'] = $this->language->get('error_filetype');
				}

				// Return any upload error
				if ($this->request->files['file']['error'] != UPLOAD_ERR_OK) {
					$json['error'] = $this->language->get('error_upload_' . $this->request->files['file']['error']);
				}
			} else {
				$json['error'] = $this->language->get('error_upload');
			}
		}

		if (!$json) {
			$data = array();

			if (($handle_import = fopen($this->request->files['file']['tmp_name'], 'r')) !== false) {
				$handle_import_data = fgetcsv($handle_import, 100000); // remove title line

				$file_columns = array(
					'ServiceID',
					'TakeFromOffice',
					'Weight',
					'OrderTotal',
					'PriceWithoutVAT',
				);

				$file_columns_indexes = array();
				foreach($handle_import_data as $index => $columnName) {
					$file_columns_indexes[$columnName] = array_search($columnName, $handle_import_data);
				}

				sort($handle_import_data);
				sort($file_columns);

				if ($handle_import_data != $file_columns) {
					$json['error'] = $this->language->get('error_file_columns');
				}

				if (!$json) {
					while (($handle_import_data = fgetcsv($handle_import, 100000)) !== false) {
						$data[] = array(
							'service_id' => $handle_import_data[$file_columns_indexes['ServiceID']],
							'take_from_office' => $handle_import_data[$file_columns_indexes['TakeFromOffice']],
							'weight' => str_replace(',', '.', $handle_import_data[$file_columns_indexes['Weight']]),
							'order_total' => str_replace(',', '.', $handle_import_data[$file_columns_indexes['OrderTotal']]),
							'price_without_vat' => str_replace(',', '.', $handle_import_data[$file_columns_indexes['PriceWithoutVAT']]),
						);
					}

					$this->model_shipping_speedy->importFilePrice($data);

					$json['fileprice_name'] = $filename;

					$json['success'] = $this->language->get('text_upload');
				}
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}

?>